#!/usr/bin/python

###################################################################################################
# Scaffolding the whole project
# Author: Javier Nievas (javinievas@gmail.com)
# Date: 6th August 2006
###################################################################################################
# BASED ON...
# Script based on the work of: 
#  - Lllama
#  - Akaihola 
#  - David Warry
###################################################################################################
# INTRODUCTION...
# The original work lives in: http://code.djangoproject.com/wiki/ScaffoldScript
# I have extended the scaffold to work for the whole project and also generate automatic urls 
# I have also put together the generation of forms and manipulators in the same file (scaffold.py) 
###################################################################################################
# Add the following line to your urls.py if you want to use automatic generated urls
# from _urls import urlpatterns
# 
# The templates are generated under your app folder, in a templates/app_label folder
# 
# This script was tested under Windows XP, using Django 0.96-pre
# You may have to change some code to match your own installation
###################################################################################################

from optparse import OptionParser
import sys
import os
from django.shortcuts import render_to_response
from django.template.loader import get_template
from scaffold import renderForm, readfile
from django.db import models
from django.template import Context, Template

TEMPLATES_FILES_PATTERN = "_%s_form.html"
APPS_FOLDER = r"../apps"
TEMPLATE_PATH_PATTERN = r"%s/%s/templates/%s"
URLS_PATH_PATTERN = r"%s/%s"

def writefile(fichero, cadena):
    f = open(fichero,"wt")
    pre = f.write(cadena)
    f.close()

urls_prefix="""
# SCAFFOLDING AUTOGENERATED URLS (by javinievas@gmail.com)
# Add the following line to your urls.py if you want to use automatic generated urls
# from _urls import urlpatterns

from django.conf.urls.defaults import *
from django.conf import settings
from contratacion.models import *

urlpatterns = patterns('')

"""
def meta_generate(app, options):
    list = models.get_models(app_mod=app.models)
    list_names = [i.__name__ for i in list]
    list_names_lower = [i.lower() for i in list_names]

    template_path = TEMPLATE_PATH_PATTERN % (APPS_FOLDER, options.app, options.app)
    urls_path = URLS_PATH_PATTERN % (APPS_FOLDER, options.app,)
    urls = ""
    print template_path
    
    print list_names
    print "Building forms..."
    for i, name in enumerate(list_names):
        template_file = os.path.join(template_path, TEMPLATES_FILES_PATTERN % list_names_lower[i])
        print "Form for '%s' in: \n\t'%s'" % (name, template_file)
        template_content = renderForm(options.app, name)
        writefile(template_file, template_content)
        urls = urls + genera_urls(app.__name__,name)
        
    print "\nBuilding _urls.py"
    writefile(os.path.join(urls_path, "_urls.py"), urls_prefix + urls)
    print "\nScaffolding completed!"

def genera_urls(app,modelo):
    template = """
# URLS of {{modelo}}

urlpatterns += patterns('django.views.generic.create_update',
    (r'^{{modelo|lower}}/new/$', 'create_object', dict({'model':{{modelo}}})),
    (r'^{{modelo|lower}}/(?P<object_id>\d+)/edit/$', 'update_object', dict({'model':{{modelo}}})),
    (r'^{{modelo|lower}}/(?P<object_id>\d+)/delete/$', 'delete_object', dict({'model':{{modelo}}})),
)
urlpatterns += patterns('{{app}}.views',
    (r'^{{modelo|lower}}/list/$','{{modelo|lower}}_list'),
)
info_dict = {
    'queryset': {{modelo}}.objects.all(),
}
urlpatterns += patterns('django.views.generic.list_detail',
    (r'^{{modelo|lower}}/(?P<object_id>\d+)/$', 'object_detail', dict(info_dict)),
)
"""
    t = Template(template)
    return t.render(Context({'modelo': modelo,'app':app}))

if __name__ == '__main__':
    try:
        import settings
    except ImportError:
        print "Settings file not found.  Place this file in the same place as manage.py"
        sys.exit()

    p = OptionParser()

    p.add_option("-p", "--project", dest="project", help="The name of the project")
    p.add_option("-a", "--app", dest="app", help="The app which contains the models")
    options, args = p.parse_args()

    if not (options.app):
        p.print_help()
        sys.exit()

    app_models = __import__("%s.models" % options.app)
    meta_generate(app_models, options)
    
