import cProfile, time, os
from django.core.handlers.modpython import ModPythonHandler

PROFILE_DATA_DIR = "/var/log/cmsprofile"

def handler(req):
    '''
    Handler that uses cProfile to store profile data.

    Adapted from django/core/handlers/profiler-hotshot.py
    '''
    profname = "%s.%.3f.prof" % (req.uri.strip("/").replace('/', '.'), time.time())
    profname = os.path.join(PROFILE_DATA_DIR, profname)
    prof = cProfile.Profile()
    results = prof.runcall(ModPythonHandler(), req)
    prof.dump_stats(profname)
    return results
