# This is an auto-generated Django model module.
# You'll have to do the following manually to clean this up:
#     * Rearrange models' order
#     * Make sure each model has one field with primary_key=True
# Feel free to rename the models, but don't rename db_table values or field names.
#
# Also note: You'll have to insert the output of 'django-admin.py sqlinitialdata [appname]'
# into your database.

from django.db import models

class Address(models.Model):
    address_id = models.IntegerField(primary_key=True)
    street_number = models.IntegerField(null=True, blank=True)
    street_name = models.CharField(blank=True, maxlength=135)
    street_suffix = models.TextField(blank=True)
    unit_number = models.CharField(blank=True, maxlength=30)
    city = models.CharField(blank=True, maxlength=135)
    county = models.CharField(blank=True, maxlength=135)
    state = models.CharField(blank=True, maxlength=60)
    country = models.CharField(blank=True, maxlength=135)
    zip = models.CharField(blank=True, maxlength=30)
    full_address = models.CharField(blank=True, maxlength=765)
    time_stamp = models.DateTimeField(null=True, blank=True)
    status_id = models.IntegerField(null=True, blank=True)
    street_prefix = models.TextField(blank=True)
    street_type = models.CharField(blank=True, maxlength=30)
    update_user_id = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'address'

class Company(models.Model):
    company_id = models.IntegerField(primary_key=True)
    parent_company_id = models.IntegerField()
    company_type_id = models.IntegerField(null=True, blank=True)
    address_id = models.IntegerField(null=True, blank=True)
    company_name = models.CharField(blank=True, maxlength=150)
    company_description = models.CharField(blank=True, maxlength=300)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'company'

class CompanyRole(models.Model):
    company_role_id = models.IntegerField(primary_key=True)
    company_id = models.IntegerField(null=True, blank=True)
    company_type_id = models.IntegerField(null=True, blank=True)
    user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'company_role'

class CompanyType(models.Model):
    company_type_id = models.IntegerField()
    company_type_name = models.CharField(blank=True, maxlength=60)
    company_type_description = models.CharField(blank=True, maxlength=765)
    user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'company_type'

class Contact(models.Model):
    contact_id = models.IntegerField(primary_key=True)
    work_phone = models.CharField(blank=True, maxlength=135)
    mobile_phone = models.CharField(blank=True, maxlength=135)
    home_phone = models.CharField(blank=True, maxlength=135)
    fax = models.CharField(blank=True, maxlength=135)
    pager = models.CharField(blank=True, maxlength=135)
    email = models.CharField(blank=True, maxlength=135)
    www = models.CharField(blank=True, maxlength=135)
    user_id = models.IntegerField(null=True, blank=True)
    status_id = models.IntegerField(null=True, blank=True)
    description = models.CharField(blank=True, maxlength=300)
    email2 = models.CharField(blank=True, maxlength=150)
    pda = models.CharField(blank=True, maxlength=150)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'contact'

class FavoriteProperty(models.Model):
    favorite_property_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField()
    property_id = models.IntegerField(null=True, blank=True)
    mls_id = models.IntegerField(null=True, blank=True)
    uuid = models.CharField(blank=True, maxlength=108)
    time_stamp = models.DateTimeField(null=True, blank=True)
    email = models.CharField(blank=True, maxlength=150)
    update_user_id = models.IntegerField(null=True, blank=True)
    list_id = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'favorite_property'

class Gmt(models.Model):
    gmt_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField(null=True, blank=True)
    gmt_adjustment = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'gmt'

class ImessageService(models.Model):
    imessage_service_id = models.IntegerField(primary_key=True)
    service_name = models.CharField(blank=True, maxlength=150)
    service_description = models.CharField(blank=True, maxlength=300)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'imessage_service'

class Message(models.Model):
    message_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField()
    message_type_id = models.IntegerField(null=True, blank=True)
    image_id = models.IntegerField(null=True, blank=True)
    link = models.CharField(blank=True, maxlength=300)
    text_message = models.CharField(blank=True, maxlength=765)
    subject = models.CharField(blank=True, maxlength=150)
    time_stamp = models.DateTimeField(null=True, blank=True)
    update_user_id = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'message'

class MessageType(models.Model):
    message_type_id = models.IntegerField(primary_key=True)
    message_type_description = models.CharField(blank=True, maxlength=60)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'message_type'

class Office(models.Model):
    office_id = models.IntegerField(primary_key=True)
    address_id = models.IntegerField(null=True, blank=True)
    contact_id = models.IntegerField(null=True, blank=True)
    office_name = models.CharField(blank=True, maxlength=135)
    broker_id = models.CharField(blank=True, maxlength=135)
    time_stamp = models.DateTimeField(null=True, blank=True)
    status_id = models.IntegerField(null=True, blank=True)
    zip = models.CharField(blank=True, maxlength=30)
    update_user_id = models.IntegerField(null=True, blank=True)
    polygon_id = models.IntegerField(null=True, blank=True)
    company_id = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'office'

class OfficePolygon(models.Model):
    office_polygon_id = models.IntegerField(primary_key=True)
    office_id = models.IntegerField(null=True, blank=True)
    polygon_id = models.IntegerField(null=True, blank=True)
    polygon_uuid = models.CharField(blank=True, maxlength=108)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'office_polygon'

class Privilege(models.Model):
    privilege_id = models.IntegerField(primary_key=True)
    privilege_name = models.CharField(blank=True, maxlength=90)
    privilege_description = models.CharField(blank=True, maxlength=765)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'privilege'

class Profile(models.Model):
    profile_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField()
    version = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    xml = models.TextField(blank=True)
    update_user_id = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'profile'

class Role(models.Model):
    role_id = models.IntegerField(primary_key=True)
    name = models.CharField(blank=True, maxlength=30)
    description = models.CharField(blank=True, maxlength=135)
    time_stamp = models.DateTimeField(null=True, blank=True)
    update_user_id = models.IntegerField(null=True, blank=True)
    class Meta:
        db_table = 'role'

class RolePrivilege(models.Model):
    role_privilege_id = models.IntegerField(primary_key=True)
    privilege_id = models.IntegerField()
    role_id = models.IntegerField()
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'role_privilege'

class UserCompany(models.Model):
    user_company_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField(null=True, blank=True)
    company_id = models.IntegerField(null=True, blank=True)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_company'

class UserImessage(models.Model):
    user_imessage_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField(null=True, blank=True)
    imessage_service_id = models.IntegerField(null=True, blank=True)
    nickname = models.CharField(blank=True, maxlength=150)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_imessage'

class UserInfo(models.Model):
    user_id = models.IntegerField(primary_key=True)
    login = models.CharField(blank=True, maxlength=765)
    first_name = models.CharField(blank=True, maxlength=60)
    middle_name = models.CharField(blank=True, maxlength=60)
    last_name = models.CharField(blank=True, maxlength=60)
    password_hash = models.CharField(blank=True, maxlength=384)
    status_id = models.IntegerField(null=True, blank=True)
    password_temp = models.CharField(blank=True, maxlength=60)
    zip = models.CharField(blank=True, maxlength=30)
    gmt_adjustment = models.TextField(blank=True) # This field type is a guess.
    ssn = models.CharField(blank=True, maxlength=27)
    question1 = models.CharField(blank=True, maxlength=90)
    question2 = models.CharField(blank=True, maxlength=90)
    question3 = models.CharField(blank=True, maxlength=90)
    answer1 = models.CharField(blank=True, maxlength=90)
    answer2 = models.CharField(blank=True, maxlength=90)
    answer3 = models.CharField(blank=True, maxlength=90)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_info'

class UserOffice(models.Model):
    user_office_id = models.IntegerField(primary_key=True)
    user_id = models.IntegerField(null=True, blank=True)
    office_id = models.IntegerField(null=True, blank=True)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_office'

class UserPolygon(models.Model):
    user_polygon_id = models.IntegerField(primary_key=True)
    user_polygon_type_id = models.IntegerField()
    user_id = models.IntegerField(null=True, blank=True)
    polygon_id = models.IntegerField(null=True, blank=True)
    polygon_uuid = models.CharField(blank=True, maxlength=108)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_polygon'

class UserPolygonType(models.Model):
    user_polygon_type_id = models.IntegerField(primary_key=True)
    type_name = models.CharField(blank=True, maxlength=90)
    type_description = models.CharField(blank=True, maxlength=300)
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_polygon_type'

class UserRole(models.Model):
    user_role_id = models.IntegerField(primary_key=True)
    role_id = models.IntegerField()
    user_id = models.IntegerField()
    update_user_id = models.IntegerField(null=True, blank=True)
    time_stamp = models.DateTimeField(null=True, blank=True)
    class Meta:
        db_table = 'user_role'

