from django.template import Node, Library, resolve_variable, TemplateSyntaxError

register = Library()

def proper(value):
    value = value.replace('_', ' ')
    return " ".join([value.capitalize() for value in value.split()])
        
class QuickForm(Node):    
    def __init__(self, parser, token):
        tokens = token.contents.split()
        self.target = tokens[1]
    
    def render_rows(self, form):
        out = []
        odd = True
        for item in form.fields:
            field = str(item)
            if (item.errors):
                field += item.html_error_list()
            if (hasattr(item.formfield, 'label')):
                label = item.formfield.label
            else:
                label = proper(item.field_name) + ":"
            row = "<tr class=%r><td class='label'><label for=%r>%s</label></td><td class='field'>%s</td></tr>" % (odd and 'odd' or 'even', item.get_id(), label, field)
            out.append(row)
        return "\n".join(out)
        
    def render(self, context):
        form = resolve_variable(self.target, context)
        out = ["<table cellpadding='0' cellspacing='0'>"]
        if (form.has_errors()):
            out.append("<tr><td colspan='2' class='error_preamble'>Please correct the errors below before continuing.</td></tr>")
        out.append(self.render_rows(form))
        out.append("</table>")
        return "\n".join(out)
        
        
class QuickFormRow(Node):    
    def __init__(self, parser, token):
        tokens = token.contents.split(None, 2)
        self.target = tokens[1]
        if (len(tokens) > 2):
            self.label = tokens[2]
        else:
            self.label = None
    
    def render(self, context):
        item = resolve_variable(self.target, context)
        if (item == ''):
            raise TemplateSyntaxError, "%r is not a valid form field with the value %r" % (self.target, item)
        field = str(item)
        if (item.errors):
            field += item.html_error_list()
        if (hasattr(item.formfield, 'label')):
            label = item.formfield.label
        else:
            label = self.label or (proper(item.field_name) + ":")
        row = "<tr><td class='label'><label for=%r>%s:</label></td><td class='field'>%s</td></tr>" % (item.get_id(), label, field)
        return row
        
register.tag('quickform', QuickForm)
register.tag('quickform-row', QuickFormRow)
