from django.contrib.auth.views import redirect_to_login
from django.http import HttpResponse
from django.utils import simplejson

class JsonResponse(HttpResponse):
    def __init__(self, obj):
        self.original_obj = obj
        HttpResponse.__init__(self, self.serialize())
        self["Content-Type"] = "text/javascript"

    def serialize(self):
        return(simplejson.dumps(self.original_obj))

def json_lookup(request, queryset, field, limit=10, login_required=False):
    """
    Method to lookup a model field and return a array. Intended for use 
    in AJAX widgets.
    """
    if login_required and not request.user.is_authenticated():
        return redirect_to_login(request.path)
    obj_list = []
    lookup = {
        '%s__istartswith' % field: request.GET['q'],
    }
    for obj in queryset.filter(**lookup)[:limit]:
        obj_list.append([getattr(obj, field), obj.id])
    return JsonResponse(obj_list)
