from django.db import models
from django.contrib.contenttypes import generic

class Item(models.Model):
	object_id=		models.PositiveIntegerField()
	content_type=	models.ForeignKey('contenttypes.ContentType')
	container=		generic.GenericForeignKey()
	
	name=models.CharField(max_length=20)
	
	def __unicode__(self):
		return self.name
	
class Container(models.Model):
	name=		models.CharField(max_length=20)
	base_items=	generic.GenericRelation('app.Item')
	
	def __unicode__(self):
		return self.name

class Cabinet(Container):
	parent=models.OneToOneField('app.container',parent_link=True, db_column='whaaaaaarrrgarbl')
	child_items=	generic.GenericRelation('app.Item')