"""
# With default sites setting of 'example.com'

>>> from django.contrib.sites.models import Site        
>>> s = Site.objects.all()[0]
>>> s.domain = 'example.com'
>>> s.save()
>>> s.domain
'example.com'

>>> HttpResponseRedirect('/i/am/a/relative/path').headers['Location']
'/i/am/a/relative/path'

>>> HttpResponseRedirect('http://www.example.com/i/am/an/absolute/path').headers['Location']
'http://www.example.com/i/am/an/absolute/path'

>>> s.domain = 'djangoproject.com'
>>> s.save()
>>> s.domain
'djangoproject.com'

>>> HttpResponseRedirect('/i/am/a/relative/path').headers['Location']
'http:/djangoproject.com/i/am/a/relative/path'

>>> HttpResponseRedirect('http://www.example.com/i/am/an/absolute/path').headers['Location']
'http://www.example.com/i/am/an/absolute/path'
"""



from django.http import HttpResponseRedirect

if __name__ == "__main__":
    import doctest
    doctest.testmod()
