from django.db import models
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes import generic

class A(models.Model):
    t = models.CharField(max_length=50)
    gr_b_reverse = generic.GenericRelation('GR_B')

class FK_B(models.Model):
    """An object with a foreign key, that we'll point to an A"""
    fk = models.ForeignKey('A')

class FK_C(models.Model):
    """An object with a foreign key, that we'll point to a FK_B"""
    fk = models.ForeignKey('FK_B')

class GR_B(models.Model):
    """An object with a generic key, that we'll point to an A"""
    content_type = models.ForeignKey(ContentType)
    object_id = models.PositiveIntegerField()
    content_obj = generic.GenericForeignKey(ct_field="content_type",
                                            fk_field="object_id")
    gr_c_reverse = generic.GenericRelation('GR_C')

class GR_C(models.Model):
    """An object with a generic key, that we'll point to a GR_B
    
    # test proper deletion of gr_c pointing to gr_b if we delete gr_b
    >>> a=A.objects.create(t='foo')
    >>> gr_b=GR_B.objects.create(content_obj=a)
    >>> gr_c=GR_C.objects.create(content_obj=gr_b)
    >>> gr_b.delete()
    >>> print A.objects.all(), GR_B.objects.all(), GR_C.objects.all()
    [<A: A object>] [] []
    >>> a.delete()
    
    # test proper deletion of gr_b pointing to a if we delete a
    >>> a=A.objects.create(t='foo')
    >>> gr_b=GR_B.objects.create(content_obj=a)
    >>> a.delete()
    >>> print A.objects.all(), GR_B.objects.all()
    [] []
    
    # test proper deletion of fk_b pointing to a, fk_c pointing to b, gr_b pointing
    # to a, and gr_c pointing to gr_b if we delete a
    >>> a=A.objects.create(t='foo')
    >>> gr_b=GR_B.objects.create(content_obj=a)
    >>> gr_c=GR_C.objects.create(content_obj=gr_b)
    >>> fk_b=FK_B.objects.create(fk=a)
    >>> fk_c=FK_C.objects.create(fk=fk_b)
    >>> print A.objects.all(), GR_B.objects.all(), GR_C.objects.all(), FK_B.objects.all(), FK_C.objects.all()
    [<A: A object>] [<GR_B: GR_B object>] [<GR_C: GR_C object>] [<FK_B: FK_B object>] [<FK_C: FK_C object>]
    >>> a.delete()
    >>> print A.objects.all(), GR_B.objects.all(), GR_C.objects.all(), FK_B.objects.all(), FK_C.objects.all()
    [] [] [] [] []
    
    # FAIL! we instead get:
    # [] [] [<GR_C: GR_C object>] [] []
    """
    
    content_type = models.ForeignKey(ContentType)
    object_id = models.PositiveIntegerField()
    content_obj = generic.GenericForeignKey(ct_field="content_type",
                                            fk_field="object_id")



