# -*- coding: utf-8 -*-
"""
List of Bulgarian cities.  Each tupple is in the following format: (u"City name", u"Phone code", u"Postal code", u"County name")

@AUTHOR: Jordan Dimov (jdimov@a115.bg)
"""
from django.utils.encoding import smart_unicode

BG_COUNTIES = (
		("E", u"Благоевград"),
		("A", u"Бургас"),
		("B", u"Варна"),
		("BT", u"Велико Търново"),
		("BH", u"Видин"),
		("BP", u"Враца"),
		("EB", u"Габрово"),
		("TX", u"Добрич"),
		("K", u"Кърджали"),
		("KH", u"Кюстендил"),
		("OB", u"Ловеч"),
		("M", u"Монтана"),
		("PA", u"Пазарджик"),
		("PK", u"Перник"),
		("EH", u"Плевен"),
		("PB", u"Пловдив"),
		("PP", u"Разград"),
		("P", u"Русе"),
		("CC", u"Силистра"),
		("CH", u"Сливен"),
		("CM", u"Смолян"),
		("CO", u"София-област"),
		("C", u"София-град"),
		("CT", u"Стара загора"),
		("T", u"Търговище"),
		("X", u"Хасково"),
		("H", u"Шумен"),
		("Y", u"Ямбол"),
		)
BG_CITIES = (
			(u"Айтос", "558", "8500", "A"), 
			(u"Аксаково", "5113", "9154", "B"), 
			(u"Алфатар", "8511", "7570", "CC"), 
			(u"Антоново", "6071", "7970", "T"), 
			(u"Априлци", "6958", "5641", "OB"), 
			(u"Ардино", "3651", "6750", "K"), 
			(u"Асеновград", "331", "4230", "PB"), 
			(u"Ахтопол", "550", "8280", "A"), 
			(u"Балчик", "579", "9600", "TX"), 
			(u"Банкя", "2997", "1320", "C"), 
			(u"Банско", "749", "2770", "E"), 
			(u"Баня", "3132", "4360", "PB"), 
			(u"Батак", "3553", "4580", "PA"), 
			(u"Батановци", "7712", "2340", "PK"), 
			(u"Белене", "658", "5930", "EH"), 
			(u"Белица", "7444", "2780", "E"), 
			(u"Белово", "3581", "4470", "PA"), 
			(u"Белоградчик", "936", "3900", "BH"), 
			(u"Белослав", "5152", "9150", "B"), 
			(u"Берковица", "953", "3500", "M"), 
			(u"Благоевград", "73", "2700", "E"), 
			(u"Бобов дол", "702", "2670", "KH"), 
			(u"Бобошево", "7046", "2660", "KH"), 
			(u"Божурище", "02993", "2227", "CO"), 
			(u"Бойчиновци", "9513", "3430", "M"), 
			(u"Болярово", "4681", "8720", "Y"), 
			(u"Борово", "8140", "7174", "P"), 
			(u"Ботевград", "723", "2140", "CO"), 
			(u"Брацигово", "3552", "4579", "PA"), 
			(u"Брегово", "9312", "3790", "BH"), 
			(u"Брезник", "7751", "2360", "PK"), 
			(u"Брезово", "3191", "4160", "PB"), 
			(u"Брусарци", "9783", "3680", "M"), 
			(u"Бургас", "56", "8000", "A"), 
			(u"Бухово", "2994", "2130", "CO"), 
			(u"Българово", "5915", "8520", "A"), 
			(u"Бяла (Област Варна)", "5143", "9101", "B"), 
			(u"Бяла (Област Русе)", "817", "7100", "P"), 
			(u"Бяла Слатина", "915", "3200", "BP"), 
			(u"Бяла черква", "6134", "5220", "BT"), 
			(u"Варна", "52", "9000", "B"), 
			(u"Велики Преслав", "538", "9850", "H"), 
			(u"Велико Търново", "62", "5000", "BT"), 
			(u"Велинград", "359", "4600", "PA"), 
			(u"Ветово", "8161", "7080", "P"), 
			(u"Ветрен", "3584", "4480", "PA"), 
			(u"Видин", "94", "3700", "BH"), 
			(u"Враца", "92", "3000", "BP"), 
			(u"Вълчедръм", "9744", "3650", "M"), 
			(u"Вълчи дол", "5131", "9280", "B"), 
			(u"Върбица", "5391", "9870", "H"), 
			(u"Вършец", "9527", "3540", "M"), 
			(u"Габрово", "66", "5300", "EB"), 
			(u"Генерал Тошево", "5731", "9500", "TX"), 
			(u"Главиница", "8636", "7630", "CC"), 
			(u"Глоджево", "8324", "7040", "P"), 
			(u"Годеч", "729", "2240", "CO"), 
			(u"Горна Оряховица", "618", "5100", "BT"), 
			(u"Гоце Делчев", "751", "2900", "E"), 
			(u"Грамада", "9337", "3830", "BH"), 
			(u"Гулянци", "6561", "5960", "EH"), 
			(u"Гурково", "4331", "6199", "CT"), 
			(u"Гълъбово", "418", "6280", "CT"), 
			(u"Две могили", "8141", "7150", "P"), 
			(u"Дебелец", "6117", "5030", "BT"), 
			(u"Девин", "3041", "4800", "CM"), 
			(u"Девня", "519", "9160", "B"), 
			(u"Джебел", "3632", "6850", "K"), 
			(u"Димитровград", "391", "6400", "X"), 
			(u"Димово", "9341", "3750", "BH"), 
			(u"Добринище", "7447", "2777", "E"), 
			(u"Добрич", "58", "9300", "TX"), 
			(u"Долни чифлик", "5142", "9120", "B"), 
			(u"Долна баня", "7120", "2040", "CO"), 
			(u"Долна Митрополия", "6552", "5855", "EH"), 
			(u"Долна Оряховица", "6173", "5130", "BT"), 
			(u"Долни Дъбник", "6514", "5870", "EH"), 
			(u"Доспат", "3045", "4831", "CM"), 
			(u"Драгоман", "7172", "2210", "CO"), 
			(u"Дряново", "676", "5370", "EB"), 
			(u"Дулово", "855", "7650", "CC"), 
			(u"Дунавци", "9314", "3740", u"Видински"), 
			(u"Дупница", "701", "2600", "KH"), 
			(u"Дългопол", "5172", "9250", "B"), 
			(u"Елена", "6151", "5070", "BT"), 
			(u"Елин Пелин", "725", "2100", "CO"), 
			(u"Елхово", "478", "8700", "Y"), 
			(u"Етрополе", "712", "2170", "CO"), 
			(u"Завет", "8342", "7330", "PP"), 
			(u"Земен", "7741", "2440", "PK"), 
			(u"Златарица", "6197", "5090", "BT"), 
			(u"Златица", "728", "2080", "CO"), 
			(u"Златоград", "3071", "4980", "CM"), 
			(u"Ивайловград", "3661", "6970", "X"), 
			(u"Искър", "6516", "5868", "EH"), 
			(u"Исперих", "835", "7400", "PP"), 
			(u"Ихтиман", "724", "2050", "CO"), 
			(u"Каблешково", "5933", "8210", "A"), 
			(u"Каварна", "570", "9650", "TX"), 
			(u"Казанлък", "431", "6100", "CT"), 
			(u"Калофер", "3133", "4370", "PB"), 
			(u"Камено", "5515", "8120", "A"), 
			(u"Каолиново", "5361", "9960", "H"), 
			(u"Карлово", "335", "4300", "PB"), 
			(u"Карнобат", "559", "8400", "A"), 
			(u"Каспичан", "5327", "9930", "H"), 
			(u"Кермен", "4516", "8870", "CH"), 
			(u"Килифарево", "6114", "5050", "BT"), 
			(u"Китен", "550", "8284", "A"), 
			(u"Клисура", "3137", "4341", "PB"), 
			(u"Кнежа", "9132", "3230", "EH"), 
			(u"Козлодуй", "973", "3320", "BP"), 
			(u"Койнаре", "6573", "3270", "EH"), 
			(u"Копривщица", "7184", "2090", "CO"), 
			(u"Костандово", "3544", "4644", "PA"), 
			(u"Костенец", "720", "2030", "CO"), 
			(u"Костинброд", "729", "2230", "CO"), 
			(u"Котел", "453", "8970", "CH"), 
			(u"Кочериново", "7053", "2640", "KH"), 
			(u"Кресна", "7433", "2840", "E"), 
			(u"Криводол", "9117", "3060", "BP"), 
			(u"Кричим", "3145", "4220", "PB"), 
			(u"Крумовград", "360", "6900", "K"), 
			(u"Кубрат", "838", "7300", "PP"), 
			(u"Куклен", "3115", "4101", "PB"), 
			(u"Кула", "938", "3800", "BH"), 
			(u"Кърджали", "361", "6600", "K"), 
			(u"Кюстендил", "78", "2500", "KH"), 
			(u"Левски", "650", "5900", "EH"), 
			(u"Летница", "6941", "5570", "OB"), 
			(u"Ловеч", "68", "5500", "OB"), 
			(u"Лозница", "8362", "7290", "PP"), 
			(u"Лом", "971", "3600", "M"), 
			(u"Луковит", "697", "5770", "OB"), 
			(u"Лъки", "3052", "4860", "PB"), 
			(u"Любимец", "3751", "6550", "X"), 
			(u"Лясковец", "6191", "5140", "BT"), 
			(u"Мадан", "308", "4900", "CM"), 
			(u"Маджарово", "3720", "6480", "X"), 
			(u"Малко Търново", "5952", "8350", "A"), 
			(u"Мартен", "8117", "7058", u"Русе"), 
			(u"Мездра", "910", "3100", "BP"), 
			(u"Мелник", "7397437", "2820", "E"), 
			(u"Меричлери", "3921", "6430", "X"), 
			(u"Мизия", "9161", "3330", "BP"), 
			(u"Момин проход", "7142", "2030", "CO"), 
			(u"Момчилград", "363", "6800", "K"), 
			(u"Монтана", "96", "3400", "M"), 
			(u"Мъглиж", "4321", "6180", "CT"), 
			(u"Неделино", "3072", "4990", "CM"), 
			(u"Несебър", "554", "8230", "A"), 
			(u"Николаево", "4330", "6190", "CT"), 
			(u"Никопол", "6541", "5940", "EH"), 
			(u"Нова Загора", "457", "8900", "CH"), 
			(u"Нови Искър", "2991", "1280", "C"), 
			(u"Нови пазар", "537", "9900", "H"), 
			(u"Обзор", "5504", "8250", "A"), 
			(u"Омуртаг", "605", "7900", "T"), 
			(u"Опака", "6039", "7840", "T"), 
			(u"Оряхово", "9171", "3300", "BP"), 
			(u"Павел баня", "4361", "6155", "CT"), 
			(u"Павликени", "610", "5200", "BT"), 
			(u"Пазарджик", "34", "4400", "PA"), 
			(u"Панагюрище", "357", "4500", "PA"), 
			(u"Перник", "76", "2300", "PK"), 
			(u"Перущица", "3143", "4225", "PB"), 
			(u"Петрич", "745", "2850", "E"), 
			(u"Пещера", "350", "4550", "PA"), 
			(u"Пирдоп", "7181", "2070", "CO"), 
			(u"Плачковци", "6770", "5360", "EB"), 
			(u"Плевен", "64", "5800", "EH"), 
			(u"Плиска", "5323", "9920", "H"), 
			(u"Пловдив", "32", "4000", "PB"), 
			(u"Полски Тръмбеш", "6141", "5180", "BT"), 
			(u"Поморие", "596", "8200", "A"), 
			(u"Попово", "608", "7800", "T"), 
			(u"Пордим", "6513", "5898", "EH"), 
			(u"Правец", "7133", "2161", "CO"), 
			(u"Приморско", "5561", "8290", "A"), 
			(u"Провадия", "518", "9200", "B"), 
			(u"Първомай", "336", "4270", "PB"), 
			(u"Раднево", "417", "6260", "CT"), 
			(u"Радомир", "777", "2400", "PK"), 
			(u"Разград", "84", "7200", "PP"), 
			(u"Разлог", "747", "2760", "E"), 
			(u"Ракитово", "3542", "4640", "PA"), 
			(u"Раковски", "3151", "4150", "PB"), 
			(u"Рила", "7054", "2630", "KH"), 
			(u"Роман", "9123", "3130", "BP"), 
			(u"Рудозем", "306", "4960", "CM"), 
			(u"Русе", "82", "7000", "P"), 
			(u"Садово", "3118", "4122", "PB"), 
			(u"Самоков", "722", "2000", "CO"), 
			(u"Сандански", "746", "2800", "E"), 
			(u"Сапарева баня", "7037", "2650", "KH"), 
			(u"Свети Влас", "554", "8256", "A"), 
			(u"Свиленград", "379", "6500", "X"), 
			(u"Свищов", "631", "5250", "BT"), 
			(u"Своге", "726", "2260", "CO"), 
			(u"Севлиево", "675", "5400", "EB"), 
			(u"Сеново", "8315", "7271", "P"), 
			(u"Септември", "3561", "4490", "PA"), 
			(u"Силистра", "86", "7500", "CC"), 
			(u"Симеоновград", "3781", "6490", "X"), 
			(u"Симитли", "7481", "2730", "E"), 
			(u"Славяново", "6515", "5840", "EH"), 
			(u"Сливен", "44", "8800", "CH"), 
			(u"Сливница", "727", "2200", "CO"), 
			(u"Сливо поле", "8131", "7060", "P"), 
			(u"Смолян", "301", "4700", "CM"), 
			(u"Смядово", "5351", "9820", "H"), 
			(u"Созопол", "550", "8130", "A"), 
			(u"Сопот", "3134", "4330", "PB"), 
			(u"София", "2", "1000", "C"), 
			(u"Средец", "5551", "8300", "A"), 
			(u"Средногорие", "728", u" ", "PB"), 
			(u"Стамболийски", "339", "4210", "PB"), 
			(u"Стара Загора", "42", "6000", "CT"), 
			(u"Стражица", "6161", "5150", "BT"), 
			(u"Стралджа", "4761", "8680", "Y"), 
			(u"Стрелча", "3532", "4530", "PA"), 
			(u"Суворово", "5153", "9170", "B"), 
			(u"Сунгурларе", "5571", "8470", "A"), 
			(u"Сухиндол", "6136", "5240", "BT"), 
			(u"Съединение", "3181", "4190", "PB"), 
			(u"Сърница", "3547", "4633", "PA"), 
			(u"Твърдица", "454", "8890", "CH"), 
			(u"Тервел", "5751", "9450", "TX"), 
			(u"Тетевен", "678", "5700", "OB"), 
			(u"Тополовград", "470", "8760", "X"), 
			(u"Троян", "670", "5600", "OB"), 
			(u"Трън", "7731", "2460", "PK"), 
			(u"Тръстеник", "6551", "5857", "EH"), 
			(u"Трявна", "677", "5350", "EB"), 
			(u"Тутракан", "857", "7600", "CC"), 
			(u"Търговище", "601", "7700", "T"), 
			(u"Угърчин", "6931", "5580", "OB"), 
			(u"Хаджидимово", "7528", "2933", "E"), 
			(u"Харманли", "373", "6450", "X"), 
			(u"Хасково", "38", "6300", "X"), 
			(u"Хисаря", "337", "4180", "PB"), 
			(u"Царево", "550", "8260", "A"), 
			(u"Цар Калоян", "8314", "7280", "PP"), 
			(u"Чепеларе", "3051", "4850", "CM"), 
			(u"Червен бряг", "659", "5980", "EH"), 
			(u"Чипровци", "9554", "3460", "M"), 
			(u"Чирпан", "416", "6200", "CT"), 
			(u"Шабла", "578", "9680", "TX"), 
			(u"Шивачево", "4593", "8895", "CH"), 
			(u"Шипка", "4324", "6150", "CT"), 
			(u"Шумен", "54", "9700", "H"), 
			(u"Ябланица", "6991", "5750", "OB"), 
			(u"Якоруда", "7442", "2790", "E"), 
			(u"Ямбол", "46", "8600", "Y"), 
		)

# City attributes
(CITY_NAME, PHONE_CODE, POST_CODE, LICENSE_PLATE, COUNTY_NAME) = (0, 1, 2, 3, 30)

def get_by_city(city, attribute):
	"""
	Returns an attribute of a city by city name.  Returns None if attribute or city can't be found.  

	Attribute can be one of: bg_cities.CITY_NAME, bg_cities.PHONE_CODE, bg_cities.POST_CODE, bg_cities.LICENSE_PLATE, bg_cities.COUNTY_NAME.  
	"""
	city = smart_unicode(city)
	try:
		if attribute==COUNTY_NAME:
			return filter(lambda c: c[0]==get_by_city(city, LICENSE_PLATE), BG_COUNTIES)[0][1]
		return filter(lambda c: c[0]==city, BG_CITIES)[0][attribute]
	except:
		return None
