from django.core.meta.fields import ImageField
from django.utils.functional import curry
from django.conf.settings import MEDIA_ROOT, MEDIA_URL

def method_get_image_thumbnail(field, self, width=None, height=None, root=MEDIA_ROOT, url_root=MEDIA_URL):
    from nesh.thumbnails.utils import make_thumbnail
    url = getattr(self, "get_%s_url" % field.name)()
    
    if (width is None) and (height is None):
        return url

    th = make_thumbnail(url, width, height, root, url_root)
    if th is not None:
        return th
    else:
        return url
#

def method_delete(name, type):
    # remove thumbnails
    file_name = getattr(type, 'get_%s_filename' % name)()
    import fnmatch, os
    base, ext = os.path.splitext(os.path.basename(file_name))
    basedir = os.path.dirname(file_name)
    for file in fnmatch.filter(os.listdir(basedir), '%s_t*%s' % (base, ext)):
        os.remove(os.path.join(basedir, file))
    # call original delete
    type._model_delete()
#

class ImageWithThumbnailField(ImageField):
    @staticmethod
    def _field_setup(cls, field):
        setattr(cls, 'get_%s_thumbnail' % field.name, curry(method_get_image_thumbnail, field))
        if hasattr(cls, 'delete'):
            orig = getattr(cls, 'delete')
            setattr(cls, 'delete', curry(method_delete, field.name))
            setattr(cls, '_model_delete', orig)
    #
    

    def get_internal_type(self):
        return 'ImageField'
    #
    
    def save_file(self, new_data, new_object, original_object, change, rel):
        super(ImageWithThumbnailField, self).save_file(new_data, new_object, original_object, change, rel)
        if change:
            # make 120px w thumbnail for admin
            getattr(new_object, 'get_%s_thumbnail' % self.name)(width=120)
    #
