
from django.utils.translation import get_language

from django.conf import settings

available_languages = settings.LANGUAGES
TRANSLATION = lambda name, code: str('%s_%s' % (name, code))

class BaseTranslatedField:
    def __init__(self, *args, **kwargs):
        self.base_args = args
        self.base_kwargs = kwargs    
    
    def contribute_to_class(self, cls, name):
        model = self.get_base_model()
        current = TRANSLATION(name, get_language())
        
        for code, description in available_languages:
            cls.add_to_class(TRANSLATION(name, code), model(*self.base_args,**self.base_kwargs))
            
        get_current = lambda self:getattr(self, current)
        get_current.admin_order_field = current
        cls.add_to_class(name, get_current)            
        
        #del self.base_args
        #del self.base_kwargs
        
class TranslatedCharField(BaseTranslatedField, models.CharField):
    def get_base_model(self):
        return models.CharField
        
class TranslatedTextField(BaseTranslatedField, models.TextField):
    def get_base_model(self):
        return models.TextField
        
        
/* SAMPLE USAGE */

class MultiLanguage(models.Model):
    name = TranslatedCharField(max_length = 255, verbose_name = _('name'))
    description = TranslatedTextField(null = True, blank = True,
    verbose_name = _('description'))

def __unicode__(self):
    return self.name()

class Meta:
    ordering = 'name_%s' % get_language(),


myobj= MultiLanguage(
    name_it = 'Tavolo',
    name_en = 'Table',
    description_it = 'Usato per mangiare',
    description_en = 'Used to eat'
    )

myobj.name()
#returns 'Tavolo', if the current lang is IT

myobj.description()
#returns 'Usato per mangiare', if the current lang is IT
