from django.db import models
from django.contrib import admin

class Person(models.Model):
    name = models.CharField(max_length=10)

class Relationship(models.Model):
    parent = models.ForeignKey(Person, related_name='parents')
    child = models.ForeignKey(Person, related_name='children')

class RelationshipInline(admin.TabularInline):
    model = Relationship
    fk_name = 'parent'
    raw_id_fields = ['child']

class PersonAdmin(admin.ModelAdmin):
    fields = ['name']
    inlines = [RelationshipInline]

admin.site.register(Person, PersonAdmin)
admin.site.register(Relationship)
