"""
Management utility to create anonuser.
"""
import random
import string
    

from django.contrib.auth.models import User, get_hexdigest

class Command(BaseCommand):
    option_list = BaseCommand.option_list
    help = 'Used to create an anonuser.'

    def handle(self, *args, **options):
        username = 'BuiltinDjangoAnonymousUser'
        try:
            anonuser = User.objects.get(username=username)
        except User.DoesNotExist:
            anonuser = User(username=username)
        
        anonuser.first_name = 'Anonymous'
        anonuser.last_name = 'User'
        anonuser.email = 'invalid@localhost.com'
        password = ""
        for n in range(0, 73):
            password += random.choice(string.printable)
                
        algo = 'sha1'
        salt = get_hexdigest(algo, str(random.random()), str(random.random()))[:5]
        hsh = get_hexdigest(algo, salt, password)
        anonuser.password = '%s$%s$%s' % (algo, salt, hsh)
        
        anonuser.save()