#!/usr/bin/env python2.6

import random
from multiprocessing import Process as Worker

from django.core.management import setup_environ
from concurrent import settings
setup_environ(settings)

from concurrent.foo.models import Foo

class ConcurrentAccess(Worker):
    def __init__(self):
        super(ConcurrentAccess, self).__init__()

    def run(self):
        f = Foo(bar=random.randint(0, 1000))
        f.save()

def launch_worker():
    w = ConcurrentAccess()
    w.start()
    return w

def main():
    workers = []
    for i in xrange(0, 100):
        workers.append(launch_worker())
    for w in workers:
        w.join()
    print("Done")

if __name__ == '__main__':
    main()
