#!/usr/bin/env python

import os
import fcntl

full_path = "/path/to/nfs-share/locktest.txt"
f = os.open(full_path, os.O_WRONLY | os.O_CREAT | os.O_EXCL | getattr(os, 'O_BINARY', 0))

def fd(f):
    return hasattr(f, 'fileno') and f.fileno() or f

try:
    fcntl.lockf(fd(f), fcntl.LOCK_EX)
finally:
    fcntl.lockf(fd(f), fcntl.LOCK_UN)
    os.close(f)
    os.remove(full_path)

# EOF

