from django.db import models
from django.contrib.auth.models import User, UserManager
from django.utils.translation import ugettext_lazy as _
from datetime import datetime


class Customuser(User):
    username = models.CharField(_('customer id'), max_length=30, unique=True, help_text=_("Required. 30 characters or fewer. Alphanumeric characters only (letters, digits and underscores)."))
    email_id = models.EmailField(_('e-mail address'), blank=True, null=True, unique=True, db_index=True)
    name = models.CharField(max_length=100, blank=True)
    address_1 = models.CharField(max_length=255, blank=True)
    address_2 = models.CharField(max_length=255, blank=True)
    city = models.CharField(max_length=80, blank=True)
    state = models.CharField(max_length=13, blank=True)
    zipcode = models.CharField(max_length=13, blank=True)
    home_phone = models.CharField(max_length=15, blank=True)
    mobile_phone = models.CharField(max_length=15, blank=True)

    CONTACT_PREFERANCE_CHOICES = (
        ('E', 'E-Mail'),
        ('M', 'Regular Mail'),
        ('P', 'Phone'),
        ('N', 'No contact'),
    )

    contact_method = models.CharField(max_length=1, choices=CONTACT_PREFERANCE_CHOICES, blank=True)
    member_since = models.DateField(blank=True, null=True)
    last_activity = models.DateField(blank=True, null=True)
    point_balance = models.IntegerField(default=0)
    NHRA_member = models.BooleanField(default=False)
    IRL_member = models.BooleanField(default=False)

    def __unicode__(self):
        return u'%s' % self.username

    # Use UserManager to get the create_user method, etc.
    objects = UserManager()

