# Create your views here.
# Create your views here.
from django import http
from django.shortcuts import render_to_response
from django.contrib.auth.decorators import login_required
from models import FileUpload
from forms import FileUploadForm

from django.shortcuts import get_object_or_404
from django.db import transaction
from django.core.urlresolvers import reverse
#from fbviews import _get_path, _get_query
import os.path
    
from django.template import RequestContext, loader
from django.http import HttpResponse, HttpResponseRedirect
from django.conf import settings
from django.utils.translation import ugettext

@login_required
@transaction.commit_on_success
def object_upload(request, model, model_form, template='object_upload.html'):
    modelname = model.__name__.replace('Upload', '')    
    if request.POST:
        form = model_form(request.POST, request.FILES)
        if form.is_valid():
            o = form.save(commit=False)
            o.save()
            if request.user.is_authenticated():
                request.user.message_set.create(message=ugettext("The %(verbose_name)s was created successfully.") % {"verbose_name": model._meta.verbose_name})
            return http.HttpResponseRedirect(reverse("top_folders"))
    else:
        form = model_form()
    return render_to_response(template, {'form':form, 'modelname':modelname}, context_instance=RequestContext(request))
