from django.db import models
from django import forms

class Department(models.Model):
    name = models.CharField(max_length=200, blank=False)

class PeopleSearchForm(forms.Form):
    people_s = forms.CharField(label='Search', required=False)
    people_d = forms.ModelChoiceField(queryset=Department.objects.all(), empty_label='-- department --', required=False)
    people_z = forms.ModelMultipleChoiceField(queryset=Department.objects.all(), required=False)


__test__ = {'API_TESTS':"""

>>> Department.objects.create(name='Monty')
<Department: Department object>
>>> Department.objects.create(name='Brian')
<Department: Department object>

# Pass data to the PeopleSearchForm #
# Empty Form
>>> f = PeopleSearchForm({})
>>> f.is_valid()
True

# Valid search
>>> f = PeopleSearchForm({'people_s': 'Monty'})
>>> f.is_valid()
True

# Invalid department search
>>> f = PeopleSearchForm({'people_d': 'Monty'})
>>> f.is_valid()
False

# Valid department multiple select
>>> f = PeopleSearchForm({'people_z': [1,2]})
>>> f.is_valid()
True

# invalid department multiple select
>>> f = PeopleSearchForm({'people_z': ['monty']})
>>> f.is_valid()
False
"""}