from django.db import models
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes import generic
from django.contrib.auth.models import User

# Create your models here.
class TestAppModel(models.Model):
    name                    = models.CharField(blank=True, max_length=100)
    
    content_type            = models.ForeignKey(ContentType)
    object_id               = models.PositiveIntegerField()
    content_object          = generic.GenericForeignKey('content_type', 'object_id')

    created_by              = models.ForeignKey(User)


