import time

from django.template import loader, Context, TemplateDoesNotExist
from django.conf import settings

settings.TEMPLATE_LOADERS = ('templatebench.load_template_source',)

def load_template_source(template_name, template_dirs=None):
    if template_name == 'base.html':
        return (base_template_source, 'base.html')
    if template_name == 'base2.html':
        return (base2_template_source, 'base2.html')
    elif template_name == 'index.html':
        return (index_template_source, 'index.html')
    raise TemplateDoesNotExist
load_template_source.is_usable = True

# our base template for testing
base_template_source = '''
{% load i18n %}
Looping in users:
{% block users %}
 {% for u in users %}
  {% with u.age as age %}
   * {% trans "Username" %}: {{ u.name }}. {% trans "Age" %}: {{ u.age }} old.
  {% endwith %}
 {% endfor %}
{% endblock %}

{% block content %}{% endblock %}
'''

base2_template_source = '''
{% extends "base.html" %}
{% load i18n %}
{% get_available_languages as langs %}
{% block content %}
  Languages: {% for lang in langs %}{{ lang.0 }} {% endfor %}
  {% block subcontent %}
  {% endblock %}
{% endblock %}
'''

# our template for testing
index_template_source = '''
{% extends "base2.html" %}
{% block subcontent %}dummy content{% endblock %}
'''

def test():
    users = [ dict(name='Foo %s' % i, age=i) for i in range(10) ]
    beg = time.time()
    for i in range(5000):
        index_template = loader.get_template('index.html')
        index_template.render(Context({'users': users}))
    end = time.time()
    print 'Bench duration: %f' % (end-beg)

if __name__ == '__main__':
    test()