def load_app(self, app_name, can_postpone=False):
    """
    Loads the app with the provided fully qualified name, and returns the
    model module.
    """
    self.handled[app_name] = None
    self.nesting_level += 1
    try:
        mod = __import__(app_name, {}, {}, ['models'])
    except Exception,e:
        exctype, value, tb = sys.exc_info()
        import traceback
        last = traceback.extract_tb(tb)[-1]
        del tb

        raise ImportError, "Failed to load models for %s, %s in %s line %s" % (app_name,e.message,last[0],last[1])
    self.nesting_level -= 1
    if not hasattr(mod, 'models'):
        if can_postpone:
            # Either the app has no models, or the package is still being
            # imported by Python and the model module isn't available yet.
            # We will check again once all the recursion has finished (in
            # populate).
            self.postponed.append(app_name)
        return None
    if mod.models not in self.app_store:
        self.app_store[mod.models] = len(self.app_store)
    return mod.models

