#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from django.conf import settings
from django.utils.translation import get_language, gettext_lazy as _

languages_available = settings.LANGUAGES

class Message(models.Model):
    """A message which is to translate"""
    text = models.TextField(_('original message'), unique=True)

    def __unicode__(self):
        """A nice representation for the user"""
        return self.text

    def save(self, *args, **kwargs):
        self.text = self.text.strip()
        super(Message, self).save(*args, **kwargs)

class Translation(models.Model):
    """Translation"""
    message = models.ForeignKey(Message)
    language = models.CharField(_('language'), max_length=5,
                        choices=settings.LANGUAGES)
    translation = models.TextField(_('translation'))

    def save(self, *args, **kwargs):
        self.translation = self.translation.strip()
        super(Translation, self).save(*args, **kwargs)

    def __unicode__(self):
        return u"%s: %s" % (self.language, self.translation)
