#!/usr/bin/env python
# -*- coding: utf-8 -*-
from sys import maxint
from django.contrib import admin
from pointtec.transdigest import models

class TranslationInline(admin.TabularInline):
    model = models.Translation

class MessageAdmin(admin.ModelAdmin):
    ordering = ('text',)
    list_per_page = maxint
    search_fields = ('text',)
    inlines = [TranslationInline]

admin.site.register(models.Message, MessageAdmin)
