from django import forms
from django.http import HttpResponseRedirect
from django.shortcuts import render_to_response

class ZipFileForm(forms.Form):
    gallery = forms.CharField()
    zip_file = forms.FileField()

def add_pictures_from_zip(request):
    if request.method == 'POST':
        form = ZipFileForm(request.POST, request.FILES)
        if form.is_valid():
            form.save()
            return HttpResponseRedirect('/admin/dali/picture/')
    else:
        form = ZipFileForm()
    
    title = "Add multiple pictures"
    return render_to_response('upload_zip_file.html', {'form': form, 'title': title})