from django.contrib import admin
from BugRepro.models import Project, Parcel, Plot, Tree

class TreeInline(admin.TabularInline):
    model = Tree
    fields = ('genus','species',)
    extra = 0
    
class PlotInline(admin.StackedInline):
    model = Plot
    fields = ('name','shape',)
    inlines = [TreeInline, ]
    extra = 0

class ParcelInline(admin.StackedInline):
    model = Parcel
    fields = ('name','area',)
    inlines = [PlotInline, ]
    extra = 0

class ProjectAdmin(admin.ModelAdmin):
    fields = ('name',)
    inlines = [ParcelInline, ]
	
admin.site.register(Project, ProjectAdmin)
