import datetime

from django.contrib import admin
from django import forms

from models import Entry, Image


class ImageForm(forms.ModelForm):
    file = forms.ImageField()
    caption = forms.CharField(label='Default caption', widget=forms.Textarea)
    caption_fi = forms.CharField(label='Caption in Finnish', required=False, widget=forms.Textarea)


class ImageInline(admin.TabularInline):
    model = Image
    extra = 1
    form = ImageForm


class EntryForm(forms.ModelForm):
    pub_date = forms.DateField(label='Publication date', initial=datetime.date.today() + datetime.timedelta(1))
    title = forms.CharField(max_length=200, required=False)
    title_fi = forms.CharField(label='Finnish title', max_length=200, required=False)
    is_memorial = forms.BooleanField(label='Use special layout?', initial=False, required=False)
    tags = forms.CharField(max_length=200,required=False)


class EntryAdmin(admin.ModelAdmin):
    date_hierachy = 'pub_date'
    list_display = ('pub_date', 'title')
    list_filter = ('pub_date',)
    ordering = ('-pub_date',)
    search_fields = ('pub_date', 'title')
    inlines = [
        ImageInline,
    ]
    form = EntryForm


admin.site.register(Entry, EntryAdmin)
