from django.db import models
from django.contrib.auth.models import User

class UserType(models.Model):
    ustid = models.IntegerField(primary_key=True)
    usttype = models.CharField("User Type", max_length=15)
    def __unicode__(self):
        return self.usttype

class UserProfile(models.Model):
    user = models.ForeignKey(User, unique=True)
    upraddr1 = models.CharField("Address line 1", max_length=50, blank=True)
    upraddr2 = models.CharField("Address line 2",max_length=50, blank=True)
    uprcity = models.CharField("City", max_length=30, blank=True)
    uprstate = models.CharField("State or Province", max_length=20, blank=True)
    uprpostcode = models.CharField("Postal Code", max_length=12, blank=True)
    uprustid = models.ForeignKey(UserType, verbose_name="User Type", blank=True)
    class Meta:
        db_table = 'UserProfile'
    def __unicode__(self):
        return "Profile for "+str(self.user)
        if self.user:
            return "%s Profile" % (self.user)
        else:
            return "WTF?"

