# -*- coding: utf-8 -*-
'''
Dictionaries containing TERYT code and names of corresponding administrative
entities.

Provinces are also known as voivodships, counties as poviats, communes as
gminas.

Source: http://isip.sejm.gov.pl/servlet/Search?todo=open&id=WDU19981571031
'''

from django.utils.translation import ugettext_lazy

PL_PROVINCES = {
    '02': ugettext_lazy(u'dolnośląskie'),
    '04': ugettext_lazy(u'kujawsko-pomorskie'),
    '06': ugettext_lazy(u'lubelskie'),
    '08': ugettext_lazy(u'lubuskie'),
    '10': ugettext_lazy(u'łódzkie'),
    '12': ugettext_lazy(u'małopolskie'),
    '14': ugettext_lazy(u'mazowieckie'),
    '16': ugettext_lazy(u'opolskie'),
    '18': ugettext_lazy(u'podkarpackie'),
    '20': ugettext_lazy(u'podlaskie'),
    '22': ugettext_lazy(u'pomorskie'),
    '24': ugettext_lazy(u'śląskie'),
    '26': ugettext_lazy(u'świętokrzyskie'),
    '28': ugettext_lazy(u'warmińsko-mazurskie'),
    '30': ugettext_lazy(u'wielkopolskie'),
    '32': ugettext_lazy(u'zachodniopomorskie'),
}

PL_COUNTIES = {
    '1021': u'brzeziński',
    '1002': u'kutnowski',
    '1003': u'łaski',
    '1004': u'łęczycki',
    '1006': u'łódzki wschodni',
    '1008': u'pabianicki',
    '1011': u'poddębicki',
    '1014': u'sieradzki',
    '1017': u'wieluński',
    '1018': u'wieruszowski',
    '1019': u'zduńskowolski',
    '1020': u'zgierski',
    '1061': u'Łódź',
    '1001': u'bełchatowski',
    '1005': u'łowicki',
    '1007': u'opoczyński',
    '1009': u'pajęczański',
    '1010': u'piotrkowski',
    '1062': u'Piotrków Trybunalski',
    '1012': u'radomszczański',
    '1013': u'rawski',
    '1063': u'Skierniewice',
    '1015': u'skierniewicki',
    '1016': u'tomaszowski',
    '1402': u'ciechanowski',
    '1404': u'gostyniński',
    '1413': u'mławski',
    '1462': u'Płock',
    '1419': u'płocki',
    '1420': u'płoński',
    '1427': u'sierpecki',
    '1437': u'żuromiński',
    '1410': u'łosicki',
    '1411': u'makowski',
    '1415': u'ostrołęcki',
    '1461': u'Ostrołęka',
    '1416': u'ostrowski',
    '1422': u'przasnyski',
    '1424': u'pułtuski',
    '1464': u'Siedlce',
    '1426': u'siedlecki',
    '1429': u'sokołowski',
    '1433': u'węgrowski',
    '1435': u'wyszkowski',
    '1401': u'białobrzeski',
    '1403': u'garwoliński',
    '1407': u'kozienicki',
    '1409': u'lipski',
    '1423': u'przysuski',
    '1463': u'Radom',
    '1425': u'radomski',
    '1430': u'szydłowiecki',
    '1436': u'zwoleński',
    '1465': u'Warszawa',
    '1405': u'grodziski',
    '1406': u'grójecki',
    '1408': u'legionowski',
    '1412': u'miński',
    '1414': u'nowodworski',
    '1417': u'otwocki',
    '1418': u'piaseczyński',
    '1421': u'pruszkowski',
    '1428': u'sochaczewski',
    '1432': u'warszawski zachodni',
    '1434': u'wołomiński',
    '1438': u'żyrardowski',
    '1201': u'bocheński',
    '1202': u'brzeski',
    '1203': u'chrzanowski',
    '1204': u'dąbrowski',
    '1206': u'krakowski',
    '1208': u'miechowski',
    '1212': u'olkuski',
    '1213': u'oświęcimski',
    '1214': u'proszowicki',
    '1216': u'tarnowski',
    '1263': u'Tarnów',
    '1219': u'wielicki',
    '1261': u'Kraków',
    '1205': u'gorlicki',
    '1207': u'limanowski',
    '1209': u'myślenicki',
    '1210': u'nowosądecki',
    '1211': u'nowotarski',
    '1262': u'Nowy Sącz',
    '1215': u'suski',
    '1217': u'tatrzański',
    '1218': u'wadowicki',
    '2462': u'Bytom',
    '2463': u'Chorzów',
    '2465': u'Dąbrowa Górnicza',
    '2466': u'Gliwice',
    '2468': u'Jaworzno',
    '2469': u'Katowice',
    '2470': u'Mysłowice',
    '2471': u'Piekary Śląskie',
    '2472': u'Ruda Śląska',
    '2474': u'Siemianowice Śląskie',
    '2475': u'Sosnowiec',
    '2476': u'Świętochłowice',
    '2477': u'Tychy',
    '2478': u'Zabrze',
    '2402': u'bielski',
    '2461': u'Bielsko-Biała',
    '2403': u'cieszyński',
    '2405': u'gliwicki',
    '2467': u'Jastrzębie-Zdrój',
    '2408': u'mikołowski',
    '2410': u'pszczyński',
    '2411': u'raciborski',
    '2412': u'rybnicki',
    '2473': u'Rybnik',
    '2414': u'tyski',
    '2415': u'wodzisławski',
    '2479': u'Żory',
    '2417': u'żywiecki',
    '2401': u'będziński',
    '2464': u'Częstochowa',
    '2404': u'częstochowski',
    '2406': u'kłobucki',
    '2407': u'lubliniecki',
    '2409': u'myszkowski',
    '2413': u'tarnogórski',
    '2416': u'zawierciański',
    '0601': u'bialski',
    '0661': u'Biała Podlaska',
    '0613': u'parczewski',
    '0615': u'radzyński',
    '0619': u'włodawski',
    '0602': u'biłgorajski',
    '0662': u'Chełm',
    '0603': u'chełmski',
    '0604': u'hrubieszowski',
    '0606': u'krasnostawski',
    '0618': u'tomaszowski',
    '0620': u'zamojski',
    '0664': u'Zamość',
    '0605': u'janowski',
    '0607': u'kraśnicki',
    '0608': u'lubartowski',
    '0609': u'lubelski',
    '0663': u'Lublin',
    '0610': u'łęczyński',
    '0611': u'łukowski',
    '0612': u'opolski',
    '0614': u'puławski',
    '0616': u'rycki',
    '0617': u'świdnicki',
    '1801': u'bieszczadzki',
    '1802': u'brzozowski',
    '1804': u'jarosławski',
    '1805': u'jasielski',
    '1861': u'Krosno',
    '1807': u'krośnieński',
    '1821': u'leski',
    '1809': u'lubaczowski',
    '1813': u'przemyski',
    '1862': u'Przemyśl',
    '1814': u'przeworski',
    '1817': u'sanocki',
    '1819': u'strzyżowski',
    '1803': u'dębicki',
    '1806': u'kolbuszowski',
    '1808': u'leżajski',
    '1810': u'łańcucki',
    '1811': u'mielecki',
    '1812': u'niżański',
    '1815': u'ropczycko-sędziszowski',
    '1816': u'rzeszowski',
    '1863': u'Rzeszów',
    '1818': u'stalowowolski',
    '1864': u'Tarnobrzeg',
    '1820': u'tarnobrzeski',
    '2001': u'augustowski',
    '2002': u'białostocki',
    '2061': u'Białystok',
    '2003': u'bielski',
    '2005': u'hajnowski',
    '2008': u'moniecki',
    '2009': u'sejneński',
    '2010': u'siemiatycki',
    '2011': u'sokólski',
    '2012': u'suwalski',
    '2063': u'Suwałki',
    '2004': u'grajewski',
    '2006': u'kolneński',
    '2062': u'Łomża',
    '2007': u'łomżyński',
    '2013': u'wysokomazowiecki',
    '2014': u'zambrowski',
    '2601': u'buski',
    '2602': u'jędrzejowski',
    '2603': u'kazimierski',
    '2661': u'Kielce',
    '2604': u'kielecki',
    '2605': u'konecki',
    '2606': u'opatowski',
    '2607': u'ostrowiecki',
    '2608': u'pińczowski',
    '2609': u'sandomierski',
    '2610': u'skarżyski',
    '2611': u'starachowicki',
    '2612': u'staszowski',
    '2613': u'włoszczowski',
    '0801': u'gorzowski',
    '0861': u'Gorzów Wielkopolski',
    '0803': u'międzyrzecki',
    '0805': u'słubicki',
    '0806': u'strzelecko-drezdenecki',
    '0807': u'sulęciński',
    '0802': u'krośnieński',
    '0804': u'nowosolski',
    '0808': u'świebodziński',
    '0812': u'wschowski',
    '0862': u'Zielona Góra',
    '0809': u'zielonogórski',
    '0810': u'żagański',
    '0811': u'żarski',
    '3004': u'gostyński',
    '3006': u'jarociński',
    '3007': u'kaliski',
    '3061': u'Kalisz',
    '3008': u'kępiński',
    '3012': u'krotoszyński',
    '3017': u'ostrowski',
    '3018': u'ostrzeszowski',
    '3020': u'pleszewski',
    '3022': u'rawicki',
    '3009': u'kolski',
    '3062': u'Konin',
    '3010': u'koniński',
    '3023': u'słupecki',
    '3027': u'turecki',
    '3001': u'chodzieski',
    '3002': u'czarnkowsko-trzcianecki',
    '3019': u'pilski',
    '3028': u'wągrowiecki',
    '3031': u'złotowski',
    '3064': u'Poznań',
    '3003': u'gnieźnieński',
    '3005': u'grodziski',
    '3011': u'kościański',
    '3013': u'leszczyński',
    '3063': u'Leszno',
    '3014': u'międzychodzki',
    '3015': u'nowotomyski',
    '3016': u'obornicki',
    '3021': u'poznański',
    '3024': u'szamotulski',
    '3025': u'średzki',
    '3026': u'śremski',
    '3029': u'wolsztyński',
    '3030': u'wrzesiński',
    '3201': u'białogardzki',
    '3203': u'drawski',
    '3208': u'kołobrzeski',
    '3261': u'Koszalin',
    '3209': u'koszaliński',
    '3213': u'sławieński',
    '3215': u'szczecinecki',
    '3216': u'świdwiński',
    '3217': u'wałecki',
    '3202': u'choszczeński',
    '3204': u'goleniowski',
    '3205': u'gryficki',
    '3206': u'gryfiński',
    '3207': u'kamieński',
    '3218': u'łobeski',
    '3210': u'myśliborski',
    '3211': u'policki',
    '3212': u'pyrzycki',
    '3214': u'stargardzki',
    '3262': u'Szczecin',
    '3263': u'Świnoujście',
    '0201': u'bolesławiecki',
    '0202': u'dzierżoniowski',
    '0205': u'jaworski',
    '0261': u'Jelenia Góra',
    '0206': u'jeleniogórski',
    '0207': u'kamiennogórski',
    '0208': u'kłodzki',
    '0210': u'lubański',
    '0212': u'lwówecki',
    '0217': u'strzeliński',
    '0219': u'świdnicki',
    '0221': u'wałbrzyski',
    '0224': u'ząbkowicki',
    '0225': u'zgorzelecki',
    '0226': u'złotoryjski',
    '0203': u'głogowski',
    '0204': u'górowski',
    '0262': u'Legnica',
    '0209': u'legnicki',
    '0211': u'lubiński',
    '0216': u'polkowicki',
    '0222': u'wołowski',
    '0264': u'Wrocław',
    '0213': u'milicki',
    '0214': u'oleśnicki',
    '0215': u'oławski',
    '0218': u'średzki',
    '0220': u'trzebnicki',
    '0223': u'wrocławski',
    '1601': u'brzeski',
    '1602': u'głubczycki',
    '1603': u'kędzierzyńsko-kozielski',
    '1604': u'kluczborski',
    '1605': u'krapkowicki',
    '1606': u'namysłowski',
    '1607': u'nyski',
    '1608': u'oleski',
    '1661': u'Opole',
    '1609': u'opolski',
    '1610': u'prudnicki',
    '1611': u'strzelecki',
    '0403': u'bydgoski',
    '0461': u'Bydgoszcz',
    '0407': u'inowrocławski',
    '0409': u'mogileński',
    '0410': u'nakielski',
    '0413': u'sępoleński',
    '0414': u'świecki',
    '0416': u'tucholski',
    '0419': u'żniński',
    '0401': u'aleksandrowski',
    '0402': u'brodnicki',
    '0404': u'chełmiński',
    '0405': u'golubsko-dobrzyński',
    '0462': u'Grudziądz',
    '0406': u'grudziądzki',
    '0408': u'lipnowski',
    '0411': u'radziejowski',
    '0412': u'rypiński',
    '0463': u'Toruń',
    '0415': u'toruński',
    '0417': u'wąbrzeski',
    '0464': u'Włocławek',
    '0418': u'włocławski',
    '2261': u'Gdańsk',
    '2262': u'Gdynia',
    '2264': u'Sopot',
    '2204': u'gdański',
    '2205': u'kartuski',
    '2206': u'kościerski',
    '2207': u'kwidzyński',
    '2209': u'malborski',
    '2210': u'nowodworski',
    '2211': u'pucki',
    '2213': u'starogardzki',
    '2216': u'sztumski',
    '2214': u'tczewski',
    '2215': u'wejherowski',
    '2201': u'bytowski',
    '2202': u'chojnicki',
    '2203': u'człuchowski',
    '2208': u'lęborski',
    '2263': u'Słupsk',
    '2212': u'słupski',
    '2802': u'braniewski',
    '2803': u'działdowski',
    '2861': u'Elbląg',
    '2804': u'elbląski',
    '2807': u'iławski',
    '2812': u'nowomiejski',
    '2815': u'ostródzki',
    '2805': u'ełcki',
    '2806': u'giżycki',
    '2818': u'gołdapski',
    '2813': u'olecki',
    '2816': u'piski',
    '2819': u'węgorzewski',
    '2801': u'bartoszycki',
    '2808': u'kętrzyński',
    '2809': u'lidzbarski',
    '2810': u'mrągowski',
    '2811': u'nidzicki',
    '2862': u'Olsztyn',
    '2814': u'olsztyński',
    '2817': u'szczycieński',
}

PL_COMMUNES = {
    '0608022': u'Abramów',
    '0611032': u'Adamów',
    '0620012': u'Adamów',
    '1814022': u'Adamówka',
    '0602022': u'Aleksandrów',
    '1010012': u'Aleksandrów',
    '0401011': u'Aleksandrów Kujawski',
    '0401042': u'Aleksandrów Kujawski',
    '1020043': u'Aleksandrów Łódzki',
    '1203013': u'Alwernia',
    '1006022': u'Andrespol',
    '1218013': u'Andrychów',
    '1416022': u'Andrzejewo',
    '0607023': u'Annopol',
    '2001011': u'Augustów',
    '2001022': u'Augustów',
    '3009022': u'Babiak',
    '1203022': u'Babice',
    '0809013': u'Babimost',
    '1602013': u'Baborów',
    '1420032': u'Baboszewo',
    '2606012': u'Baćkowice',
    '2012012': u'Bakałarzewo',
    '1821012': u'Baligród',
    '2607022': u'Bałtów',
    '3206012': u'Banie',
    '2818012': u'Banie Mazurskie',
    '1415012': u'Baranowo',
    '0614022': u'Baranów',
    '1405032': u'Baranów',
    '3008012': u'Baranów',
    '1820013': u'Baranów Sandomierski',
    '2808022': u'Barciany',
    '0419013': u'Barcin',
    '2814013': u'Barczewo',
    '0224013': u'Bardo',
    '2001032': u'Bargłów Kościelny',
    '3210013': u'Barlinek',
    '2801011': u'Bartoszyce',
    '2801032': u'Bartoszyce',
    '0418022': u'Baruchowo',
    '3215023': u'Barwice',
    '0605012': u'Batorz',
    '0401052': u'Bądkowo',
    '1002022': u'Bedlno',
    '2603012': u'Bejsce',
    '1406012': u'Belsk Duży',
    '1001011': u'Bełchatów',
    '1001022': u'Bełchatów',
    '0618022': u'Bełżec',
    '0609013': u'Bełżyce',
    '1465028': u'Bemowo',
    '1817022': u'Besko',
    '2402022': u'Bestwina',
    '1016022': u'Będków',
    '2401011': u'Będzin',
    '3209012': u'Będzino',
    '1017012': u'Biała',
    '1610013': u'Biała',
    '1007012': u'Białaczów',
    '2816013': u'Biała Piska',
    '0601032': u'Biała Podlaska',
    '1013023': u'Biała Rawska',
    '0403012': u'Białe Błota',
    '1401013': u'Białobrzegi',
    '1810022': u'Białobrzegi',
    '3201011': u'Białogard',
    '3201022': u'Białogard',
    '1465038': u'Białołęka',
    '0603022': u'Białopole',
    '3019022': u'Białośliwie',
    '2005022': u'Białowieża',
    '3215033': u'Biały Bór',
    '1217022': u'Biały Dunajec',
    '1205023': u'Biecz',
    '1429022': u'Bielany',
    '1465048': u'Bielany',
    '0202011': u'Bielawa',
    '1005022': u'Bielawy',
    '3212012': u'Bielice',
    '2604012': u'Bieliny',
    '1419012': u'Bielsk',
    '2003011': u'Bielsk Podlaski',
    '2003032': u'Bielsk Podlaski',
    '1603022': u'Bierawa',
    '2414011': u'Bieruń',
    '0214023': u'Bierutów',
    '3202012': u'Bierzwnik',
    '3209022': u'Biesiekierz',
    '1437013': u'Bieżuń',
    '0602011': u'Biłgoraj',
    '0602032': u'Biłgoraj',
    '1813012': u'Bircza',
    '1219012': u'Biskupice',
    '2812022': u'Biskupiec',
    '2814023': u'Biskupiec',
    '0602042': u'Biszcza',
    '2801043': u'Bisztynek',
    '2404013': u'Blachownia',
    '0803012': u'Bledzew',
    '3007012': u'Blizanów',
    '2610022': u'Bliżyn',
    '1014023': u'Błaszki',
    '1816023': u'Błażowa',
    '1406022': u'Błędów',
    '1432013': u'Błonie',
    '3209033': u'Bobolice',
    '1205032': u'Bobowa',
    '2213042': u'Bobowo',
    '0802022': u'Bobrowice',
    '0408022': u'Bobrowniki',
    '2401042': u'Bobrowniki',
    '0402022': u'Bobrowo',
    '1201011': u'Bochnia',
    '1201022': u'Bochnia',
    '2003042': u'Boćki',
    '1419022': u'Bodzanów',
    '2607032': u'Bodzechów',
    '2604023': u'Bodzentyn',
    '0225033': u'Bogatynia',
    '0801022': u'Bogdaniec',
    '2612012': u'Bogoria',
    '1816032': u'Boguchwała',
    '0221011': u'Boguszów-Gorce',
    '1416032': u'Boguty-Pianki',
    '0809022': u'Bojadła',
    '3022013': u'Bojanowo',
    '1818022': u'Bojanów',
    '2414042': u'Bojszowy',
    '1204012': u'Bolesław',
    '1212032': u'Bolesław',
    '0201011': u'Bolesławiec',
    '0201022': u'Bolesławiec',
    '1018012': u'Bolesławiec',
    '3210022': u'Boleszkowice',
    '1015012': u'Bolimów',
    '0205023': u'Bolków',
    '0418032': u'Boniewo',
    '3004013': u'Borek Wielkopolski',
    '0615022': u'Borki',
    '1423012': u'Borkowice',
    '3215043': u'Borne Sulinowo',
    '2407022': u'Boronów',
    '1811022': u'Borowa',
    '1403032': u'Borowie',
    '0217012': u'Borów',
    '0609022': u'Borzechów',
    '1202012': u'Borzęcin',
    '2201012': u'Borzytuchom',
    '3008022': u'Bralin',
    '1602022': u'Branice',
    '2802011': u'Braniewo',
    '2802022': u'Braniewo',
    '2003021': u'Brańsk',
    '2003052': u'Brańsk',
    '1435012': u'Brańszczyk',
    '1014032': u'Brąszewice',
    '2403042': u'Brenna',
    '1428022': u'Brochów',
    '0402011': u'Brodnica',
    '0402032': u'Brodnica',
    '3026012': u'Brodnica',
    '0811032': u'Brody',
    '2611022': u'Brody',
    '3205012': u'Brojce',
    '1416043': u'Brok',
    '1006032': u'Brójce',
    '1419032': u'Brudzeń Duży',
    '3027022': u'Brudzew',
    '2202023': u'Brusy',
    '1421033': u'Brwinów',
    '1601011': u'Brzeg',
    '0222013': u'Brzeg Dolny',
    '1202023': u'Brzesko',
    '1213023': u'Brzeszcze',
    '0418043': u'Brześć Kujawski',
    '1021011': u'Brzeziny',
    '1021022': u'Brzeziny',
    '3007022': u'Brzeziny',
    '0810032': u'Brzeźnica',
    '1218022': u'Brzeźnica',
    '1014042': u'Brzeźnio',
    '3216022': u'Brzeżno',
    '1803022': u'Brzostek',
    '0402042': u'Brzozie',
    '1802013': u'Brzozów',
    '0412022': u'Brzuze',
    '1805022': u'Brzyska',
    '1003012': u'Buczek',
    '2402032': u'Buczkowice',
    '2819012': u'Budry',
    '1016032': u'Budziszewice',
    '1215032': u'Budzów',
    '3001022': u'Budzyń',
    '3021033': u'Buk',
    '0414012': u'Bukowiec',
    '1217032': u'Bukowina Tatrzańska',
    '1212011': u'Bukowno',
    '1817032': u'Bukowsko',
    '1419042': u'Bulkowo',
    '1014052': u'Burzenin',
    '2601013': u'Busko-Zdrój',
    '0609033': u'Bychawa',
    '1604013': u'Byczyna',
    '1215042': u'Bystra-Sidzina',
    '0208063': u'Bystrzyca Kłodzka',
    '0802032': u'Bytnica',
    '0804023': u'Bytom Odrzański',
    '0411022': u'Bytoń',
    '2201023': u'Bytów',
    '2204022': u'Cedry Wielkie',
    '3206023': u'Cedynia',
    '1412042': u'Cegłów',
    '0416012': u'Cekcyn',
    '3007032': u'Ceków-Kolonia',
    '1417032': u'Celestynów',
    '1429032': u'Ceranów',
    '2208032': u'Cewice',
    '1208012': u'Charsznica',
    '1005032': u'Chąśno',
    '0603032': u'Chełm',
    '1213033': u'Chełmek',
    '1210022': u'Chełmiec',
    '0404011': u'Chełmno',
    '0404022': u'Chełmno',
    '2414052': u'Chełm Śląski',
    '0415011': u'Chełmża',
    '0415022': u'Chełmża',
    '2604033': u'Chęciny',
    '1430012': u'Chlewiska',
    '1804032': u'Chłopice',
    '1816042': u'Chmielnik',
    '2604043': u'Chmielnik',
    '2205012': u'Chmielno',
    '0418052': u'Choceń',
    '0216013': u'Chocianów',
    '3214023': u'Chociwel',
    '3020012': u'Chocz',
    '2215042': u'Choczewo',
    '0418063': u'Chodecz',
    '0612012': u'Chodel',
    '3009032': u'Chodów',
    '3001011': u'Chodzież',
    '3001032': u'Chodzież',
    '3206033': u'Chojna',
    '2202011': u'Chojnice',
    '2202032': u'Chojnice',
    '0209011': u'Chojnów',
    '0209022': u'Chojnów',
    '1807012': u'Chorkówka',
    '2002013': u'Choroszcz',
    '1422023': u'Chorzele',
    '3202023': u'Choszczno',
    '1409012': u'Chotcza',
    '0408032': u'Chrostkowo',
    '0605022': u'Chrzanów',
    '1203033': u'Chrzanów',
    '1609012': u'Chrząstowice',
    '3014012': u'Chrzypsko Wielkie',
    '2403052': u'Chybie',
    '1406032': u'Chynów',
    '2407032': u'Ciasna',
    '2013023': u'Ciechanowiec',
    '1402011': u'Ciechanów',
    '1402022': u'Ciechanów',
    '0405022': u'Ciechocin',
    '0401021': u'Ciechocinek',
    '1013032': u'Cielądz',
    '1409022': u'Ciepielów',
    '0224022': u'Ciepłowody',
    '1809023': u'Cieszanów',
    '0213012': u'Cieszków',
    '2403011': u'Cieszyn',
    '1216013': u'Ciężkowice',
    '1603032': u'Cisek',
    '1821022': u'Cisna',
    '1806012': u'Cmolas',
    '0805013': u'Cybinka',
    '0610012': u'Cyców',
    '3018012': u'Czajków',
    '3203013': u'Czaplinek',
    '1801032': u'Czarna',
    '1803032': u'Czarna',
    '1810032': u'Czarna',
    '2002023': u'Czarna Białostocka',
    '2201032': u'Czarna Dąbrówka',
    '2213011': u'Czarna Woda',
    '2203023': u'Czarne',
    '1415022': u'Czarnia',
    '3002011': u'Czarnków',
    '3002022': u'Czarnków',
    '1010022': u'Czarnocin',
    '2603022': u'Czarnocin',
    '1017022': u'Czarnożyły',
    '0221042': u'Czarny Bór',
    '1211032': u'Czarny Dunajec',
    '1018022': u'Czastary',
    '1202033': u'Czchów',
    '2402043': u'Czechowice-Dziedzice',
    '2401021': u'Czeladź',
    '0615032': u'Czemierniki',
    '3011023': u'Czempiń',
    '2005032': u'Czeremcha',
    '1811032': u'Czermin',
    '3020022': u'Czermin',
    '0223012': u'Czernica',
    '1422032': u'Czernice Borowe',
    '1206012': u'Czernichów',
    '2417022': u'Czernichów',
    '3003023': u'Czerniejewo',
    '1016042': u'Czerniewice',
    '0415032': u'Czernikowo',
    '2202043': u'Czersk',
    '0809033': u'Czerwieńsk',
    '1415032': u'Czerwin',
    '1420042': u'Czerwińsk nad Wisłą',
    '2412013': u'Czerwionka-Leszczyny',
    '3021042': u'Czerwonak',
    '1411022': u'Czerwonka',
    '3217023': u'Człopa',
    '2203011': u'Człuchów',
    '2203032': u'Człuchów',
    '1211042': u'Czorsztyn',
    '1414022': u'Czosnów',
    '1819012': u'Czudec',
    '2005042': u'Czyże',
    '2013032': u'Czyżew-Osada',
    '2607043': u'Ćmielów',
    '2604053': u'Daleszyce',
    '1011012': u'Dalików',
    '3028022': u'Damasławek',
    '2212022': u'Damnica',
    '3213011': u'Darłowo',
    '3213032': u'Darłowo',
    '1004022': u'Daszyna',
    '0802042': u'Dąbie',
    '3009043': u'Dąbie',
    '0409012': u'Dąbrowa',
    '1609022': u'Dąbrowa',
    '2011013': u'Dąbrowa Białostocka',
    '0407022': u'Dąbrowa Biskupia',
    '0403022': u'Dąbrowa Chełmińska',
    '1204023': u'Dąbrowa Tarnowska',
    '2404022': u'Dąbrowa Zielona',
    '1002032': u'Dąbrowice',
    '1434052': u'Dąbrówka',
    '2815022': u'Dąbrówno',
    '2203043': u'Debrzno',
    '0801032': u'Deszczno',
    '1412052': u'Dębe Wielkie',
    '1803011': u'Dębica',
    '1803042': u'Dębica',
    '0616011': u'Dęblin',
    '2212032': u'Dębnica Kaszubska',
    '1202042': u'Dębno',
    '3210033': u'Dębno',
    '0613012': u'Dębowa Kłoda',
    '0417022': u'Dębowa Łąka',
    '1805032': u'Dębowiec',
    '2403062': u'Dębowiec',
    '0223022': u'Długołęka',
    '1435022': u'Długosiodło',
    '1008032': u'Dłutów',
    '1021032': u'Dmosin',
    '1209013': u'Dobczyce',
    '0806013': u'Dobiegniew',
    '1207032': u'Dobra',
    '3027033': u'Dobra',
    '3218013': u'Dobra',
    '3211012': u'Dobra (Szczecińska)',
    '0403032': u'Dobrcz',
    '0411032': u'Dobre',
    '1412062': u'Dobre',
    '2814033': u'Dobre Miasto',
    '1608013': u'Dobrodzień',
    '0219032': u'Dobromierz',
    '1008042': u'Dobroń',
    '0214032': u'Dobroszyce',
    '1012022': u'Dobryszyce',
    '3214033': u'Dobrzany',
    '1609032': u'Dobrzeń Wielki',
    '3020032': u'Dobrzyca',
    '2002032': u'Dobrzyniewo Duże',
    '0408043': u'Dobrzyń nad Wisłą',
    '3214042': u'Dolice',
    '3026023': u'Dolsk',
    '0604022': u'Dołhobyczów',
    '1426012': u'Domanice',
    '1005042': u'Domaniewice',
    '0215022': u'Domaniów',
    '1802022': u'Domaradz',
    '1606012': u'Domaszowice',
    '3025012': u'Dominowo',
    '3021052': u'Dopiewo',
    '0603042': u'Dorohusk',
    '3018022': u'Doruchów',
    '0414022': u'Dragacz',
    '3202033': u'Drawno',
    '3002032': u'Drawsko',
    '3203023': u'Drawsko Pomorskie',
    '0601042': u'Drelów',
    '0806023': u'Drezdenko',
    '1419053': u'Drobin',
    '2010023': u'Drohiczyn',
    '1001032': u'Drużbice',
    '1201032': u'Drwinia',
    '1007023': u'Drzewica',
    '0414032': u'Drzycim',
    '2818022': u'Dubeninki',
    '2005052': u'Dubicze Cerkiewne',
    '1813022': u'Dubiecko',
    '0603052': u'Dubienka',
    '1807023': u'Dukla',
    '3024022': u'Duszniki',
    '0208011': u'Duszniki-Zdrój',
    '2609022': u'Dwikozy',
    '1802032': u'Dydnia',
    '3208022': u'Dygowo',
    '1816011': u'Dynów',
    '1816052': u'Dynów',
    '2814042': u'Dywity',
    '2010032': u'Dziadkowice',
    '0214042': u'Dziadowa Kłoda',
    '2803011': u'Działdowo',
    '2803022': u'Działdowo',
    '2608013': u'Działoszyce',
    '1009013': u'Działoszyn',
    '2206022': u'Dziemiany',
    '1420052': u'Dzierzążnia',
    '2216013': u'Dzierzgoń',
    '1413022': u'Dzierzgowo',
    '0607032': u'Dzierzkowice',
    '0202021': u'Dzierżoniów',
    '0202052': u'Dzierżoniów',
    '1806062': u'Dzikowiec',
    '3207013': u'Dziwnów',
    '0605032': u'Dzwola',
    '2817022': u'Dźwierzuty',
    '2804012': u'Elbląg',
    '2805011': u'Ełk',
    '2805022': u'Ełk',
    '0418072': u'Fabianki',
    '0606022': u'Fajsławice',
    '2605012': u'Fałków',
    '2012022': u'Filipów',
    '0608032': u'Firlej',
    '0602053': u'Frampol',
    '1813032': u'Fredropol',
    '2802033': u'Frombork',
    '1819022': u'Frysztak',
    '1814032': u'Gać',
    '1018032': u'Galewice',
    '1407012': u'Garbatka-Letnisko',
    '0609042': u'Garbów',
    '2207022': u'Gardeja',
    '1403011': u'Garwolin',
    '1403042': u'Garwolin',
    '2412022': u'Gaszowice',
    '1811042': u'Gawłuszowice',
    '0216022': u'Gaworzyce',
    '1419063': u'Gąbin',
    '0419022': u'Gąsawa',
    '1219022': u'Gdów',
    '2009022': u'Giby',
    '1012032': u'Gidle',
    '1423022': u'Gielniów',
    '2405032': u'Gierałtowice',
    '2814052': u'Gietrzwałd',
    '2417032': u'Gilowice',
    '3020042': u'Gizałki',
    '2806011': u'Giżycko',
    '2806042': u'Giżycko',
    '1402033': u'Glinojeck',
    '0203011': u'Głogów',
    '0203022': u'Głogów',
    '1610023': u'Głogówek',
    '1816063': u'Głogów Małopolski',
    '1407022': u'Głowaczów',
    '1020011': u'Głowno',
    '1020052': u'Głowno',
    '2212042': u'Główczyce',
    '1602033': u'Głubczyce',
    '1607013': u'Głuchołazy',
    '1015022': u'Głuchów',
    '0609052': u'Głusk',
    '0221053': u'Głuszyca',
    '2214023': u'Gniew',
    '2215052': u'Gniewino',
    '0407033': u'Gniewkowo',
    '1407032': u'Gniewoszów',
    '3003011': u'Gniezno',
    '3003032': u'Gniezno',
    '1202052': u'Gnojnik',
    '2601022': u'Gnojno',
    '2410012': u'Goczałkowice-Zdrój',
    '2804022': u'Godkowo',
    '2415052': u'Godów',
    '1015032': u'Godzianów',
    '3007042': u'Godziesze Wielkie',
    '0605042': u'Godziszów',
    '1605013': u'Gogolin',
    '3207023': u'Golczewo',
    '3204023': u'Goleniów',
    '2403072': u'Goleszów',
    '3010013': u'Golina',
    '0405011': u'Golub-Dobrzyń',
    '0405032': u'Golub-Dobrzyń',
    '3028033': u'Gołańcz',
    '1208022': u'Gołcza',
    '2818033': u'Gołdap',
    '3020052': u'Gołuchów',
    '1402042': u'Gołymin-Ośrodek',
    '1012042': u'Gomunice',
    '2008013': u'Goniądz',
    '0602062': u'Goraj',
    '1205011': u'Gorlice',
    '1205042': u'Gorlice',
    '1010032': u'Gorzkowice',
    '0606032': u'Gorzków',
    '1608023': u'Gorzów Śląski',
    '1820022': u'Gorzyce',
    '2415062': u'Gorzyce',
    '0416022': u'Gostycyn',
    '1404011': u'Gostynin',
    '1404022': u'Gostynin',
    '3004023': u'Gostyń',
    '1014062': u'Goszczanów',
    '1406042': u'Goszczyn',
    '0607042': u'Gościeradów',
    '3208032': u'Gościno',
    '2605022': u'Gowarczów',
    '1415042': u'Goworowo',
    '0810011': u'Gozdnica',
    '1427022': u'Gozdowo',
    '0204013': u'Góra',
    '1418013': u'Góra Kalwaria',
    '1004032': u'Góra Świętej Małgorzaty',
    '2604062': u'Górno',
    '2801021': u'Górowo Iławeckie',
    '2801052': u'Górowo Iławeckie',
    '0402053': u'Górzno',
    '1403052': u'Górzno',
    '0805022': u'Górzyca',
    '1425022': u'Gózd',
    '1010042': u'Grabica',
    '0620022': u'Grabowiec',
    '2006022': u'Grabowo',
    '1004042': u'Grabów',
    '1407042': u'Grabów nad Pilicą',
    '3018033': u'Grabów nad Prosną',
    '2004011': u'Grajewo',
    '2004022': u'Grajewo',
    '3005012': u'Granowo',
    '0402062': u'Grążawy',
    '1433022': u'Grębków',
    '0216032': u'Grębocice',
    '1204032': u'Gręboszów',
    '1820032': u'Grębów',
    '1601033': u'Grodków',
    '2812032': u'Grodziczno',
    '3010022': u'Grodziec',
    '2010042': u'Grodzisk',
    '1405043': u'Grodzisk Mazowiecki',
    '1808022': u'Grodzisko Dolne',
    '3005023': u'Grodzisk Wielkopolski',
    '0201032': u'Gromadka',
    '1216022': u'Gromnik',
    '2804032': u'Gronowo Elbląskie',
    '2002042': u'Gródek',
    '1210032': u'Gródek nad Dunajcem',
    '1406053': u'Grójec',
    '1402052': u'Grudusk',
    '0406012': u'Grudziądz',
    '2815032': u'Grunwald',
    '0406022': u'Gruta',
    '1210011': u'Grybów',
    '1210042': u'Grybów',
    '3205023': u'Gryfice',
    '3206043': u'Gryfino',
    '0212013': u'Gryfów Śląski',
    '3009052': u'Grzegorzew',
    '3215052': u'Grzmiąca',
    '0802011': u'Gubin',
    '0802052': u'Gubin',
    '1424012': u'Gzy',
    '1802042': u'Haczów',
    '2005011': u'Hajnówka',
    '2005062': u'Hajnówka',
    '1412073': u'Halinów',
    '0619022': u'Hanna',
    '0619032': u'Hańsk',
    '1812012': u'Harasiuki',
    '2403082': u'Hażlach',
    '2211011': u'Hel',
    '2407042': u'Herby',
    '0604032': u'Horodło',
    '1809032': u'Horyniec-Zdrój',
    '0604011': u'Hrubieszów',
    '0604042': u'Hrubieszów',
    '1410012': u'Huszlew',
    '1816072': u'Hyżne',
    '1206022': u'Igołomia-Wawrzeńczyce',
    '2807011': u'Iława',
    '2807032': u'Iława',
    '0810043': u'Iłowa',
    '2803032': u'Iłowo-Osada',
    '1428032': u'Iłów',
    '1425033': u'Iłża',
    '2414021': u'Imielin',
    '2602012': u'Imielno',
    '1016052': u'Inowłódz',
    '0407011': u'Inowrocław',
    '0407042': u'Inowrocław',
    '3214053': u'Ińsko',
    '2416032': u'Irządze',
    '2403092': u'Istebna',
    '2606022': u'Iwaniska',
    '1206032': u'Iwanowice',
    '1815012': u'Iwierzyce',
    '1202062': u'Iwkowa',
    '1807033': u'Iwonicz-Zdrój',
    '1432022': u'Izabelin',
    '0606042': u'Izbica',
    '0418083': u'Izbica Kujawska',
    '1611012': u'Izbicko',
    '1211052': u'Jabłonka',
    '0609062': u'Jabłonna',
    '1408022': u'Jabłonna',
    '1429042': u'Jabłonna Lacka',
    '0402073': u'Jabłonowo Pomorskie',
    '0613022': u'Jabłoń',
    '1434062': u'Jadów',
    '1405052': u'Jaktorów',
    '1412082': u'Jakubów',
    '0407053': u'Janikowo',
    '0206052': u'Janowice Wielkie',
    '0614032': u'Janowiec',
    '2811012': u'Janowiec Kościelny',
    '0419033': u'Janowiec Wielkopolski',
    '2811022': u'Janowo',
    '2011022': u'Janów',
    '2404032': u'Janów',
    '0605053': u'Janów Lubelski',
    '0601052': u'Janów Podlaski',
    '3006012': u'Jaraczewo',
    '0618032': u'Jarczów',
    '1812022': u'Jarocin',
    '3006023': u'Jarocin',
    '1804011': u'Jarosław',
    '1804042': u'Jarosław',
    '2402052': u'Jasienica',
    '1802052': u'Jasienica Rosielna',
    '1406062': u'Jasieniec',
    '0811043': u'Jasień',
    '2008022': u'Jasionówka',
    '1805011': u'Jasło',
    '1805042': u'Jasło',
    '2211021': u'Jastarnia',
    '0609072': u'Jastków',
    '3031023': u'Jastrowie',
    '1430022': u'Jastrząb',
    '1425042': u'Jastrzębia',
    '2008032': u'Jaświły',
    '0205011': u'Jawor',
    '1814042': u'Jawornik Polski',
    '2402062': u'Jaworze',
    '0219043': u'Jaworzyna Śląska',
    '1807043': u'Jedlicze',
    '0221021': u'Jedlina-Zdrój',
    '1425052': u'Jedlińsk',
    '1425062': u'Jedlnia-Letnisko',
    '1422042': u'Jednorożec',
    '2007013': u'Jedwabne',
    '2817032': u'Jedwabno',
    '2412032': u'Jejkowice',
    '0215033': u'Jelcz-Laskowice',
    '2012032': u'Jeleniewo',
    '2417042': u'Jeleśnia',
    '1611022': u'Jemielnica',
    '0204022': u'Jemielno',
    '0203032': u'Jerzmanowa',
    '1206042': u'Jerzmanowice-Przeginia',
    '2814063': u'Jeziorany',
    '0409022': u'Jeziora Wielkie',
    '0608042': u'Jeziorzany',
    '0414042': u'Jeżewo',
    '1812032': u'Jeżowe',
    '1021042': u'Jeżów',
    '0206062': u'Jeżów Sudecki',
    '2602023': u'Jędrzejów',
    '1803052': u'Jodłowa',
    '1207042': u'Jodłownik',
    '1420062': u'Joniec',
    '2814072': u'Jonkowo',
    '1215011': u'Jordanów',
    '1215052': u'Jordanów',
    '0223032': u'Jordanów Śląski',
    '0602073': u'Józefów',
    '1417011': u'Józefów',
    '0612022': u'Józefów nad Wisłą',
    '2002052': u'Juchnowiec Kościelny',
    '3022023': u'Jutrosin',
    '3019032': u'Kaczory',
    '1415052': u'Kadzidło',
    '2413011': u'Kalety',
    '2805032': u'Kalinowo',
    '2213052': u'Kaliska',
    '3203033': u'Kalisz Pomorski',
    '1218033': u'Kalwaria Zebrzydowska',
    '1412093': u'Kałuszyn',
    '1207052': u'Kamienica',
    '2404042': u'Kamienica Polska',
    '3005032': u'Kamieniec',
    '0224032': u'Kamieniec Ząbkowicki',
    '0207011': u'Kamienna Góra',
    '0207022': u'Kamienna Góra',
    '1607022': u'Kamiennik',
    '0603062': u'Kamień',
    '1816082': u'Kamień',
    '0413013': u'Kamień Krajeński',
    '3207033': u'Kamień Pomorski',
    '1012053': u'Kamieńsk',
    '0608052': u'Kamionka',
    '1210052': u'Kamionka Wielka',
    '1432032': u'Kampinos',
    '1814053': u'Kańczuga',
    '1417043': u'Karczew',
    '0612032': u'Karczmiska',
    '0809043': u'Kargowa',
    '3201033': u'Karlino',
    '3205032': u'Karnice',
    '1411032': u'Karniewo',
    '0206011': u'Karpacz',
    '2206032': u'Karsin',
    '2205023': u'Kartuzy',
    '3027042': u'Kawęczyn',
    '1436012': u'Kazanów',
    '2603033': u'Kazimierza Wielka',
    '3010032': u'Kazimierz Biskupi',
    '0614043': u'Kazimierz Dolny',
    '3024032': u'Kaźmierz',
    '0615042': u'Kąkolewnica Wschodnia',
    '0223043': u'Kąty Wrocławskie',
    '0410013': u'Kcynia',
    '1603011': u'Kędzierzyn-Koźle',
    '2212053': u'Kępice',
    '3008033': u'Kępno',
    '0416032': u'Kęsowo',
    '2808011': u'Kętrzyn',
    '2808032': u'Kętrzyn',
    '1213043': u'Kęty',
    '1009022': u'Kiełczygłów',
    '1005052': u'Kiernozia',
    '1602043': u'Kietrz',
    '2608022': u'Kije',
    '0404032': u'Kijewo Królewskie',
    '0408052': u'Kikół',
    '2807043': u'Kisielice',
    '3003042': u'Kiszkowo',
    '2809022': u'Kiwity',
    '3010043': u'Kleczew',
    '1434072': u'Klembów',
    '2005073': u'Kleszczele',
    '3021062': u'Kleszczewo',
    '1001042': u'Kleszczów',
    '2609032': u'Klimontów',
    '1014072': u'Klonowa',
    '1604023': u'Kluczbork',
    '1212042': u'Klucze',
    '2613012': u'Kluczewsko',
    '1001052': u'Kluki',
    '2013042': u'Klukowo',
    '1423032': u'Klwów',
    '1219032': u'Kłaj',
    '3003053': u'Kłecko',
    '2406013': u'Kłobuck',
    '0616022': u'Kłoczew',
    '0801042': u'Kłodawa',
    '3009063': u'Kłodawa',
    '0208021': u'Kłodzko',
    '0208072': u'Kłodzko',
    '2404052': u'Kłomnice',
    '2405011': u'Knurów',
    '2008043': u'Knyszyn',
    '1012062': u'Kobiele Wielkie',
    '0223052': u'Kobierzyce',
    '2410022': u'Kobiór',
    '3018042': u'Kobyla Góra',
    '3214062': u'Kobylanka',
    '3012023': u'Kobylin',
    '2013052': u'Kobylin-Borzymy',
    '2212062': u'Kobylnica',
    '1434011': u'Kobyłka',
    '2407052': u'Kochanowice',
    '1005062': u'Kocierzew Południowy',
    '0608063': u'Kock',
    '1206052': u'Kocmyrzów-Luborzyca',
    '2203052': u'Koczała',
    '0601062': u'Kodeń',
    '1012072': u'Kodrąb',
    '2204032': u'Kolbudy',
    '1806023': u'Kolbuszowa',
    '2006011': u'Kolno',
    '2006032': u'Kolno',
    '2814082': u'Kolno',
    '1611033': u'Kolonowskie',
    '0804032': u'Kolsko',
    '1006073': u'Koluszki',
    '3030012': u'Kołaczkowo',
    '1805052': u'Kołaczyce',
    '2014022': u'Kołaki Kościelne',
    '3211022': u'Kołbaskowo',
    '1417052': u'Kołbiel',
    '2201042': u'Kołczygłowy',
    '3009011': u'Koło',
    '3009072': u'Koło',
    '3208011': u'Kołobrzeg',
    '3208042': u'Kołobrzeg',
    '1817042': u'Komańcza',
    '0615052': u'Komarówka Podlaska',
    '0620032': u'Komarów-Osada',
    '3021072': u'Komorniki',
    '1609042': u'Komprachcice',
    '2202052': u'Konarzyny',
    '0217022': u'Kondratowice',
    '0401062': u'Koneck',
    '2404063': u'Koniecpol',
    '1214012': u'Koniusza',
    '2404072': u'Konopiska',
    '0609082': u'Konopnica',
    '1017032': u'Konopnica',
    '1418023': u'Konstancin-Jeziorna',
    '0601072': u'Konstantynów',
    '1008011': u'Konstantynów Łódzki',
    '2605033': u'Końskie',
    '0614052': u'Końskowola',
    '2609043': u'Koprzywnica',
    '1426022': u'Korczew',
    '1807052': u'Korczyna',
    '1607033': u'Korfantów',
    '2411022': u'Kornowac',
    '0403043': u'Koronowo',
    '2808043': u'Korsze',
    '2011032': u'Korycin',
    '1433032': u'Korytnica',
    '1210062': u'Korzenna',
    '2211052': u'Kosakowo',
    '1429053': u'Kosów Lacki',
    '0218012': u'Kostomłoty',
    '3021083': u'Kostrzyn',
    '0801011': u'Kostrzyn nad Odrą',
    '2417052': u'Koszarawa',
    '2407062': u'Koszęcin',
    '1214022': u'Koszyce',
    '3011011': u'Kościan',
    '3011032': u'Kościan',
    '3009082': u'Kościelec',
    '1217042': u'Kościelisko',
    '2206011': u'Kościerzyna',
    '2206042': u'Kościerzyna',
    '0203042': u'Kotla',
    '3006032': u'Kotlin',
    '1426032': u'Kotuń',
    '0418011': u'Kowal',
    '0418092': u'Kowal',
    '1425072': u'Kowala',
    '2813032': u'Kowale Oleckie',
    '0405043': u'Kowalewo Pomorskie',
    '0206021': u'Kowary',
    '1015042': u'Kowiesy',
    '2409023': u'Koziegłowy',
    '3212022': u'Kozielice',
    '1407053': u'Kozienice',
    '2811032': u'Kozłowo',
    '1208032': u'Kozłów',
    '2402072': u'Kozy',
    '3007052': u'Koźminek',
    '3012033': u'Koźmin Wielkopolski',
    '0804043': u'Kożuchów',
    '3021093': u'Kórnik',
    '3031033': u'Krajenka',
    '3010052': u'Kramsk',
    '1605023': u'Krapkowice',
    '1813042': u'Krasiczyn',
    '1422052': u'Krasne',
    '1816092': u'Krasne',
    '0620043': u'Krasnobród',
    '2009032': u'Krasnopol',
    '1411042': u'Krasnosielc',
    '0606011': u'Krasnystaw',
    '0606052': u'Krasnystaw',
    '2613022': u'Krasocin',
    '3018052': u'Kraszewice',
    '0606062': u'Kraśniczyn',
    '0607011': u'Kraśnik',
    '0607052': u'Kraśnik',
    '1805062': u'Krempna',
    '3004033': u'Krobia',
    '2416042': u'Kroczyce',
    '2211062': u'Krokowa',
    '0802063': u'Krosno Odrzańskie',
    '1211062': u'Krościenko nad Dunajcem',
    '1807062': u'Krościenko Wyżne',
    '0213022': u'Krośnice',
    '1002043': u'Krośniewice',
    '0209032': u'Krotoszyce',
    '3012043': u'Krotoszyn',
    '2806052': u'Kruklanki',
    '2413052': u'Krupski Młyn',
    '0407063': u'Kruszwica',
    '2404082': u'Kruszyna',
    '2210011': u'Krynica Morska',
    '1210073': u'Krynica-Zdrój',
    '0618042': u'Krynice',
    '2011042': u'Krynki',
    '2008052': u'Krypno',
    '2411033': u'Krzanowice',
    '0609092': u'Krzczonów',
    '3013012': u'Krzemieniewo',
    '2406023': u'Krzepice',
    '1206063': u'Krzeszowice',
    '1812042': u'Krzeszów',
    '0807012': u'Krzeszyce',
    '3202042': u'Krzęcin',
    '3025022': u'Krzykosy',
    '3010062': u'Krzymów',
    '1422062': u'Krzynowłoga Mała',
    '1813052': u'Krzywcza',
    '0611042': u'Krzywda',
    '3011043': u'Krzywiń',
    '2411042': u'Krzyżanowice',
    '1002052': u'Krzyżanów',
    '3002043': u'Krzyż Wielkopolski',
    '1008052': u'Ksawerów',
    '0417032': u'Książki',
    '1208042': u'Książ Wielki',
    '3026033': u'Książ Wielkopolski',
    '0602082': u'Księżpol',
    '1437022': u'Kuczbork-Osada',
    '0208031': u'Kudowa-Zdrój',
    '2013062': u'Kulesze Kościelne',
    '0209042': u'Kunice',
    '2607053': u'Kunów',
    '0614062': u'Kurów',
    '1808032': u'Kuryłówka',
    '2812042': u'Kurzętnik',
    '3015012': u'Kuślin',
    '1002011': u'Kutno',
    '1002062': u'Kutno',
    '2411053': u'Kuźnia Raciborska',
    '2011052': u'Kuźnica',
    '2207011': u'Kwidzyn',
    '2207032': u'Kwidzyn',
    '3014022': u'Kwilcz',
    '1218042': u'Lanckorona',
    '1207062': u'Laskowa',
    '1604032': u'Lasowice Wielkie',
    '1804052': u'Laszki',
    '1412102': u'Latowicz',
    '3023022': u'Lądek',
    '0208083': u'Lądek-Zdrój',
    '1408011': u'Legionowo',
    '0209052': u'Legnickie Pole',
    '1415062': u'Lelis',
    '2802042': u'Lelkowo',
    '2404092': u'Lelów',
    '1414032': u'Leoncin',
    '1821033': u'Lesko',
    '1432042': u'Leszno',
    '1418032': u'Lesznowola',
    '0210033': u'Leśna',
    '0601082': u'Leśna Podlaska',
    '1611043': u'Leśnica',
    '0603072': u'Leśniowice',
    '1601043': u'Lewin Brzeski',
    '0208092': u'Lewin Kłodzki',
    '1808011': u'Leżajsk',
    '1808042': u'Leżajsk',
    '2208011': u'Lębork',
    '2414031': u'Lędziny',
    '1012082': u'Lgota Wielka',
    '1203043': u'Libiąż',
    '2209032': u'Lichnowy',
    '2803043': u'Lidzbark',
    '2809011': u'Lidzbark Warmiński',
    '2809032': u'Lidzbark Warmiński',
    '1207011': u'Limanowa',
    '1207072': u'Limanowa',
    '2215062': u'Linia',
    '2206052': u'Liniewo',
    '1015052': u'Lipce Reymontowskie',
    '3212033': u'Lipiany',
    '2406032': u'Lipie',
    '1205052': u'Lipinki',
    '0811052': u'Lipinki Łużyckie',
    '3031042': u'Lipka',
    '2201052': u'Lipnica',
    '1201042': u'Lipnica Murowana',
    '1211072': u'Lipnica Wielka',
    '2606032': u'Lipnik',
    '0408011': u'Lipno',
    '0408062': u'Lipno',
    '3013022': u'Lipno',
    '2417062': u'Lipowa',
    '1413032': u'Lipowiec Kościelny',
    '2001043': u'Lipsk',
    '1409033': u'Lipsko',
    '2206062': u'Lipusz',
    '0404042': u'Lisewo',
    '1216032': u'Lisia Góra',
    '3007062': u'Lisków',
    '1206072': u'Liszki',
    '1433042': u'Liw',
    '0414052': u'Lniano',
    '1809011': u'Lubaczów',
    '1809042': u'Lubaczów',
    '0418102': u'Lubanie',
    '0210011': u'Lubań',
    '0210042': u'Lubań',
    '0608011': u'Lubartów',
    '0608072': u'Lubartów',
    '3002052': u'Lubasz',
    '2807021': u'Lubawa',
    '2807052': u'Lubawa',
    '0207033': u'Lubawka',
    '1816102': u'Lubenia',
    '2213062': u'Lubichowo',
    '0415042': u'Lubicz',
    '1209022': u'Lubień',
    '0418113': u'Lubień Kujawski',
    '0416042': u'Lubiewo',
    '0211011': u'Lubin',
    '0211022': u'Lubin',
    '0801052': u'Lubiszyn',
    '2407011': u'Lubliniec',
    '0807023': u'Lubniewice',
    '1016062': u'Lubochnia',
    '2415072': u'Lubomia',
    '0212023': u'Lubomierz',
    '2809042': u'Lubomino',
    '3021011': u'Luboń',
    '1437032': u'Lubowidz',
    '0418123': u'Lubraniec',
    '0808012': u'Lubrza',
    '1610032': u'Lubrza',
    '0811063': u'Lubsko',
    '1601052': u'Lubsza',
    '0618052': u'Lubycza Królewska',
    '0610022': u'Ludwin',
    '1437042': u'Lutocin',
    '1008062': u'Lutomiersk',
    '1801052': u'Lutowiska',
    '1018042': u'Lututów',
    '2215072': u'Luzino',
    '3015023': u'Lwówek',
    '0212033': u'Lwówek Śląski',
    '2412042': u'Lyski',
    '0419043': u'Łabiszyn',
    '1210082': u'Łabowa',
    '0620052': u'Łabunie',
    '1012092': u'Ładzice',
    '0202062': u'Łagiewniki',
    '0808022': u'Łagów',
    '2604072': u'Łagów',
    '1607042': u'Łambinowice',
    '1002072': u'Łanięta',
    '1810011': u'Łańcut',
    '1810042': u'Łańcut',
    '1201052': u'Łapanów',
    '1211082': u'Łapsze Niżne',
    '2002063': u'Łapy',
    '0406033': u'Łasin',
    '1003023': u'Łask',
    '1403021': u'Łaskarzew',
    '1403062': u'Łaskarzew',
    '0618062': u'Łaszczów',
    '0612042': u'Łaziska',
    '2408011': u'Łaziska Górne',
    '2416053': u'Łazy',
    '1419072': u'Łąck',
    '1210092': u'Łącko',
    '2610032': u'Łączna',
    '2208021': u'Łeba',
    '0610033': u'Łęczna',
    '1004011': u'Łęczyca',
    '1004052': u'Łęczyca',
    '2215082': u'Łęczyce',
    '3008042': u'Łęka Opatowska',
    '2417072': u'Łękawica',
    '1010052': u'Łęki Szlacheckie',
    '0811011': u'Łęknica',
    '3218023': u'Łobez',
    '3019043': u'Łobżenica',
    '1433053': u'Łochów',
    '2417082': u'Łodygowice',
    '0601092': u'Łomazy',
    '1432053': u'Łomianki',
    '2007022': u'Łomża',
    '2609052': u'Łoniów',
    '0606072': u'Łopiennik Górny',
    '2604082': u'Łopuszno',
    '1410023': u'Łosice',
    '1210102': u'Łososina Dolna',
    '1005011': u'Łowicz',
    '1005072': u'Łowicz',
    '1061029': u'Łódź-Bałuty',
    '1061039': u'Łódź-Górna',
    '1061049': u'Łódź-Polesie',
    '1061059': u'Łódź-Śródmieście',
    '1061069': u'Łódź-Widzew',
    '0415052': u'Łubianka',
    '1609052': u'Łubniany',
    '1018052': u'Łubnice',
    '2612022': u'Łubnice',
    '3003062': u'Łubowo',
    '0602092': u'Łukowa',
    '1207082': u'Łukowica',
    '0611011': u'Łuków',
    '0611052': u'Łuków',
    '2815042': u'Łukta',
    '1205062': u'Łużna',
    '1415072': u'Łyse',
    '0415062': u'Łysomice',
    '1005082': u'Łyszkowice',
    '1403072': u'Maciejowice',
    '1407062': u'Magnuszew',
    '1806032': u'Majdan Królewski',
    '1015062': u'Maków',
    '1411011': u'Maków Mazowiecki',
    '1215063': u'Maków Podhalański',
    '3027052': u'Malanów',
    '2209011': u'Malbork',
    '2209042': u'Malbork',
    '0218022': u'Malczyce',
    '3213042': u'Malechowo',
    '1419082': u'Mała Wieś',
    '2815052': u'Małdyty',
    '1416052': u'Małkinia Górna',
    '2602033': u'Małogoszcz',
    '0810053': u'Małomice',
    '2006042': u'Mały Płock',
    '3209042': u'Manowo',
    '0219052': u'Marcinowice',
    '0207042': u'Marciszów',
    '3001043': u'Margonin',
    '3214082': u'Marianowo',
    '1434021': u'Marki',
    '2415082': u'Marklowice',
    '1810052': u'Markowa',
    '2804042': u'Markusy',
    '0614072': u'Markuszów',
    '1012102': u'Masłowice',
    '2604092': u'Masłów',
    '0802072': u'Maszewo',
    '3204033': u'Maszewo',
    '0661011': u'Biała Podlaska',
    '2061011': u'Białystok',
    '2461011': u'Bielsko-Biała',
    '0461011': u'Bydgoszcz',
    '2462011': u'Bytom',
    '0662011': u'Chełm',
    '2463011': u'Chorzów',
    '2464011': u'Częstochowa',
    '2465011': u'Dąbrowa Górnicza',
    '1813062': u'Medyka',
    '2861011': u'Elbląg',
    '0617022': u'Mełgiew',
    '0205032': u'Męcinka',
    '1204042': u'Mędrzechów',
    '2261011': u'Gdańsk',
    '2262011': u'Gdynia',
    '2466011': u'Gliwice',
    '0861011': u'Gorzów Wielkopolski',
    '0462011': u'Grudziądz',
    '3019052': u'Miasteczko Krajeńskie',
    '2413021': u'Miasteczko Śląskie',
    '2201063': u'Miastko',
    '2007032': u'Miastkowo',
    '1403082': u'Miastków Kościelny',
    '0620062': u'Miączyn',
    '1206082': u'Michałowice',
    '1421042': u'Michałowice',
    '2002072': u'Michałowo',
    '2608032': u'Michałów',
    '0608082': u'Michów',
    '1208053': u'Miechów',
    '2604102': u'Miedziana Góra',
    '3015032': u'Miedzichowo',
    '1433062': u'Miedzna',
    '2410032': u'Miedźna',
    '2406042': u'Miedźno',
    '1807072': u'Miejsce Piastowe',
    '3022033': u'Miejska Górka',
    '1811011': u'Mielec',
    '1811052': u'Mielec',
    '3003072': u'Mieleszyn',
    '2010052': u'Mielnik',
    '3209052': u'Mielno',
    '0221063': u'Mieroszów',
    '2401052': u'Mierzęcice',
    '3206053': u'Mieszkowice',
    '3028042': u'Mieścisko',
    '0223062': u'Mietków',
    '0214053': u'Międzybórz',
    '3014033': u'Międzychód',
    '0208103': u'Międzylesie',
    '0601011': u'Międzyrzec Podlaski',
    '0601102': u'Międzyrzec Podlaski',
    '0803023': u'Międzyrzecz',
    '3207043': u'Międzyzdroje',
    '0218032': u'Miękinia',
    '2810023': u'Mikołajki',
    '2216022': u'Mikołajki Pomorskie',
    '2408021': u'Mikołów',
    '3018063': u'Mikstat',
    '0613032': u'Milanów',
    '1405011': u'Milanówek',
    '2010062': u'Milejczyce',
    '2804052': u'Milejewo',
    '0610042': u'Milejów',
    '0213033': u'Milicz',
    '2417092': u'Milówka',
    '2815063': u'Miłakowo',
    '2806062': u'Miłki',
    '0209062': u'Miłkowice',
    '2815073': u'Miłomłyn',
    '2209062': u'Miłoradz',
    '3030023': u'Miłosław',
    '1412011': u'Mińsk Mazowiecki',
    '1412112': u'Mińsk Mazowiecki',
    '0604052': u'Mircze',
    '3217033': u'Mirosławiec',
    '1430032': u'Mirów',
    '0212043': u'Mirsk',
    '2611032': u'Mirzec',
    '2467011': u'Jastrzębie-Zdrój',
    '2468011': u'Jaworzno',
    '0261011': u'Jelenia Góra',
    '3061011': u'Kalisz',
    '2469011': u'Katowice',
    '2661011': u'Kielce',
    '3062011': u'Konin',
    '3261011': u'Koszalin',
    '1261011': u'Kraków',
    '1861011': u'Krosno',
    '0262011': u'Legnica',
    '3063011': u'Leszno',
    '0663011': u'Lublin',
    '1413011': u'Mława',
    '1428042': u'Młodzieszyn',
    '2062011': u'Łomża',
    '1061011': u'Łódź',
    '2804063': u'Młynary',
    '1411052': u'Młynarze',
    '2470011': u'Mysłowice',
    '2604112': u'Mniów',
    '1007032': u'Mniszków',
    '1262011': u'Nowy Sącz',
    '1427032': u'Mochowo',
    '0605062': u'Modliborzyce',
    '1406073': u'Mogielnica',
    '1206092': u'Mogilany',
    '0409033': u'Mogilno',
    '1426042': u'Mokobody',
    '1465058': u'Mokotów',
    '1017042': u'Mokrsko',
    '2862011': u'Olsztyn',
    '2008063': u'Mońki',
    '1661011': u'Opole',
    '2604122': u'Morawica',
    '2815083': u'Morąg',
    '1426053': u'Mordy',
    '3206063': u'Moryń',
    '2214032': u'Morzeszczyn',
    '3021103': u'Mosina',
    '2613032': u'Moskorzew',
    '1461011': u'Ostrołęka',
    '1010062': u'Moszczenica',
    '1205072': u'Moszczenica',
    '2471011': u'Piekary Śląskie',
    '1062011': u'Piotrków Trybunalski',
    '1462011': u'Płock',
    '3064011': u'Poznań',
    '1862011': u'Przemyśl',
    '1463011': u'Radom',
    '2810011': u'Mrągowo',
    '2810032': u'Mrągowo',
    '0410023': u'Mrocza',
    '1412122': u'Mrozy',
    '2472011': u'Ruda Śląska',
    '2473011': u'Rybnik',
    '1863011': u'Rzeszów',
    '1464011': u'Siedlce',
    '2474011': u'Siemianowice Śląskie',
    '1063011': u'Skierniewice',
    '2263011': u'Słupsk',
    '2264011': u'Sopot',
    '2475011': u'Sosnowiec',
    '2404102': u'Mstów',
    '1465011': u'Warszawa',
    '2063011': u'Suwałki',
    '2415092': u'Mszana',
    '1207021': u'Mszana Dolna',
    '1207092': u'Mszana Dolna',
    '3262011': u'Szczecin',
    '1438023': u'Mszczonów',
    '0205042': u'Mściwojów',
    '2476011': u'Świętochłowice',
    '3263011': u'Świnoujście',
    '1864011': u'Tarnobrzeg',
    '1263011': u'Tarnów',
    '0463011': u'Toruń',
    '2477011': u'Tychy',
    '1218052': u'Mucharz',
    '3021113': u'Murowana Goślina',
    '1609062': u'Murów',
    '1210113': u'Muszyna',
    '0464011': u'Włocławek',
    '0264011': u'Wrocław',
    '3007072': u'Mycielin',
    '2404112': u'Mykanów',
    '0206072': u'Mysłakowice',
    '2409011': u'Myszków',
    '1415083': u'Myszyniec',
    '1209033': u'Myślenice',
    '3210043': u'Myślibórz',
    '2478011': u'Zabrze',
    '0664011': u'Zamość',
    '0862011': u'Zielona Góra',
    '2479011': u'Żory',
    '1421052': u'Nadarzyn',
    '2602042': u'Nagłowice',
    '0410033': u'Nakło nad Notecią',
    '0614083': u'Nałęczów',
    '1606023': u'Namysłów',
    '2005082': u'Narew',
    '2005092': u'Narewka',
    '1809053': u'Narol',
    '1420072': u'Naruszewo',
    '1414043': u'Nasielsk',
    '1210122': u'Nawojowa',
    '3030033': u'Nekla',
    '2411062': u'Nędza',
    '2811043': u'Nidzica',
    '1005092': u'Nieborów',
    '1819032': u'Niebylec',
    '3003082': u'Niechanowo',
    '0204032': u'Niechlów',
    '0609102': u'Niedrzwica Duża',
    '0608092': u'Niedźwiada',
    '1207102': u'Niedźwiedź',
    '0810062': u'Niegosławice',
    '2409032': u'Niegowa',
    '0620072': u'Nielisz',
    '0609112': u'Niemce',
    '0202073': u'Niemcza',
    '1609073': u'Niemodlin',
    '1219043': u'Niepołomice',
    '1408032': u'Nieporęt',
    '0401031': u'Nieszawa',
    '1812053': u'Nisko',
    '1806042': u'Niwiska',
    '1009032': u'Nowa Brzeźnica',
    '1820043': u'Nowa Dęba',
    '2206072': u'Nowa Karczma',
    '0208041': u'Nowa Ruda',
    '0208112': u'Nowa Ruda',
    '1808053': u'Nowa Sarzyna',
    '2604132': u'Nowa Słupia',
    '0804011': u'Nowa Sól',
    '0804052': u'Nowa Sól',
    '1428052': u'Nowa Sucha',
    '2208042': u'Nowa Wieś Lęborska',
    '0403052': u'Nowa Wieś Wielka',
    '0414063': u'Nowe',
    '1214032': u'Nowe Brzesko',
    '0804063': u'Nowe Miasteczko',
    '1420082': u'Nowe Miasto',
    '2812011': u'Nowe Miasto Lubawskie',
    '2812052': u'Nowe Miasto Lubawskie',
    '1406083': u'Nowe Miasto nad Pilicą',
    '3025032': u'Nowe Miasto nad Wartą',
    '1002082': u'Nowe Ostrowy',
    '2013072': u'Nowe Piekuty',
    '3017023': u'Nowe Skalmierzyce',
    '3211033': u'Nowe Warpno',
    '2001052': u'Nowinka',
    '0616032': u'Nowodwór',
    '3204043': u'Nowogard',
    '0201043': u'Nowogrodziec',
    '2007043': u'Nowogród',
    '0809053': u'Nowogród Bobrzański',
    '3210052': u'Nowogródek Pomorski',
    '1006082': u'Nowosolna',
    '1419092': u'Nowy Duninów',
    '2011062': u'Nowy Dwór',
    '2210023': u'Nowy Dwór Gdański',
    '1414011': u'Nowy Dwór Mazowiecki',
    '1015072': u'Nowy Kawęczyn',
    '2601032': u'Nowy Korczyn',
    '2209073': u'Nowy Staw',
    '1211011': u'Nowy Targ',
    '1211092': u'Nowy Targ',
    '3015043': u'Nowy Tomyśl',
    '1201063': u'Nowy Wiśnicz',
    '1805072': u'Nowy Żmigród',
    '1802062': u'Nozdrzec',
    '1416062': u'Nur',
    '2010072': u'Nurzec-Stacja',
    '1607053': u'Nysa',
    '3016013': u'Oborniki',
    '0220013': u'Oborniki Śląskie',
    '2609062': u'Obrazów',
    '0415072': u'Obrowo',
    '1424022': u'Obryte',
    '3024011': u'Obrzycko',
    '3024042': u'Obrzycko',
    '0602102': u'Obsza',
    '1465068': u'Ochota',
    '1211102': u'Ochotnica Dolna',
    '3017033': u'Odolanów',
    '1423042': u'Odrzywół',
    '2416063': u'Ogrodzieniec',
    '1402062': u'Ojrzeń',
    '3031053': u'Okonek',
    '2602052': u'Oksa',
    '2813043': u'Olecko',
    '1204052': u'Olesno',
    '1608033': u'Olesno',
    '1809063': u'Oleszyce',
    '0214011': u'Oleśnica',
    '0214062': u'Oleśnica',
    '2612032': u'Oleśnica',
    '1212053': u'Olkusz',
    '1821042': u'Olszanica',
    '1410032': u'Olszanka',
    '1601062': u'Olszanka',
    '1415092': u'Olszewo-Borki',
    '3009092': u'Olszówka',
    '2404122': u'Olsztyn',
    '2814093': u'Olsztynek',
    '0210052': u'Olszyna',
    '0215011': u'Oława',
    '0215042': u'Oława',
    '3015053': u'Opalenica',
    '2603042': u'Opatowiec',
    '2406052': u'Opatów',
    '2606043': u'Opatów',
    '3007082': u'Opatówek',
    '1402072': u'Opinogóra Górna',
    '1007043': u'Opoczno',
    '0612053': u'Opole Lubelskie',
    '1002092': u'Oporów',
    '3023032': u'Orchowo',
    '2003062': u'Orla',
    '1813072': u'Orły',
    '2809053': u'Orneta',
    '2408042': u'Ornontowice',
    '1430042': u'Orońsko',
    '2408031': u'Orzesze',
    '2816023': u'Orzysz',
    '0414072': u'Osie',
    '1417062': u'Osieck',
    '2213072': u'Osieczna',
    '3013033': u'Osieczna',
    '0201052': u'Osiecznica',
    '0402082': u'Osiek',
    '1213052': u'Osiek',
    '2213082': u'Osiek',
    '2612043': u'Osiek',
    '1805082': u'Osiek Jasielski',
    '3009102': u'Osiek Mały',
    '0403062': u'Osielsko',
    '0411042': u'Osięciny',
    '3204052': u'Osina',
    '1017052': u'Osjaków',
    '2210032': u'Ostaszewo',
    '3024053': u'Ostroróg',
    '3203042': u'Ostrowice',
    '2607011': u'Ostrowiec Świętokrzyski',
    '3023042': u'Ostrowite',
    '2815011': u'Ostróda',
    '2815092': u'Ostróda',
    '1815022': u'Ostrów',
    '0608112': u'Ostrówek',
    '1017062': u'Ostrówek',
    '0608103': u'Ostrów Lubelski',
    '1416011': u'Ostrów Mazowiecka',
    '1416072': u'Ostrów Mazowiecka',
    '3017011': u'Ostrów Wielkopolski',
    '3017042': u'Ostrów Wielkopolski',
    '3018073': u'Ostrzeszów',
    '0805033': u'Ośno Lubuskie',
    '1213011': u'Oświęcim',
    '1213062': u'Oświęcim',
    '1607063': u'Otmuchów',
    '1417021': u'Otwock',
    '0804072': u'Otyń',
    '1609083': u'Ozimek',
    '1020021': u'Ozorków',
    '1020062': u'Ozorków',
    '2413062': u'Ożarowice',
    '2606053': u'Ożarów',
    '1432063': u'Ożarów Mazowiecki',
    '1008021': u'Pabianice',
    '1008072': u'Pabianice',
    '2601042': u'Pacanów',
    '1404032': u'Pacyna',
    '1607073': u'Paczków',
    '1811062': u'Padew Narodowa',
    '1009043': u'Pajęczno',
    '3022042': u'Pakosław',
    '1607082': u'Pakosławice',
    '0407073': u'Pakość',
    '1214042': u'Pałecznica',
    '2406062': u'Panki',
    '0404052': u'Papowo Biskupie',
    '1426062': u'Paprotnia',
    '1007052': u'Paradyż',
    '2201072': u'Parchowo',
    '0613043': u'Parczew',
    '1403092': u'Parysów',
    '1020072': u'Parzęczew',
    '2804073': u'Pasłęk',
    '2817043': u'Pasym',
    '0205052': u'Paszowice',
    '1804062': u'Pawłosiów',
    '2410042': u'Pawłowice',
    '1603042': u'Pawłowiczki',
    '2611042': u'Pawłów',
    '2407072': u'Pawonków',
    '1017072': u'Pątnów',
    '1209042': u'Pcim',
    '2214043': u'Pelplin',
    '3202053': u'Pełczyce',
    '2010082': u'Perlejewo',
    '3008052': u'Perzów',
    '0203052': u'Pęcław',
    '1011022': u'Pęczniew',
    '3004042': u'Pępowo',
    '1418043': u'Piaseczno',
    '0617033': u'Piaski',
    '3004052': u'Piaski',
    '1421011': u'Piastów',
    '1004062': u'Piątek',
    '2007052': u'Piątnica',
    '0206031': u'Piechowice',
    '2810042': u'Piecki',
    '2604142': u'Piekoszów',
    '0226032': u'Pielgrzymka',
    '2802053': u'Pieniężno',
    '0225043': u'Pieńsk',
    '2604152': u'Pierzchnica',
    '0202031': u'Pieszyce',
    '2411072': u'Pietrowice Wielkie',
    '1403103': u'Pilawa',
    '2405042': u'Pilchowice',
    '2416073': u'Pilica',
    '1803063': u'Pilzno',
    '3019011': u'Piła',
    '0202041': u'Piława Górna',
    '2608043': u'Pińczów',
    '1425011': u'Pionki',
    '1425082': u'Pionki',
    '0411053': u'Piotrków Kujawski',
    '2816033': u'Pisz',
    '0601112': u'Piszczac',
    '1210133': u'Piwniczna-Zdrój',
    '1410042': u'Platerów',
    '0210062': u'Platerówka',
    '3020063': u'Pleszew',
    '1216042': u'Pleśna',
    '2001062': u'Płaska',
    '1411062': u'Płoniawy-Bramura',
    '1420011': u'Płońsk',
    '1420092': u'Płońsk',
    '2802062': u'Płoskinia',
    '2803052': u'Płośnica',
    '3205043': u'Płoty',
    '0417042': u'Płużnica',
    '1406092': u'Pniewy',
    '3024063': u'Pniewy',
    '3021123': u'Pobiedziska',
    '2404132': u'Poczesna',
    '1011033': u'Poddębice',
    '0613052': u'Podedwórze',
    '1210142': u'Podegrodzie',
    '0206082': u'Podgórzyn',
    '1405021': u'Podkowa Leśna',
    '3004063': u'Pogorzela',
    '1606032': u'Pokój',
    '1424032': u'Pokrzywnica',
    '0208051': u'Polanica-Zdrój',
    '1213072': u'Polanka Wielka',
    '3209063': u'Polanów',
    '3211043': u'Police',
    '1436022': u'Policzna',
    '0216043': u'Polkowice',
    '1603052': u'Polska Cerekiew',
    '3002062': u'Połajewo',
    '2612053': u'Połaniec',
    '3216033': u'Połczyn-Zdrój',
    '1414052': u'Pomiechówek',
    '0612063': u'Poniatowa',
    '3004073': u'Poniec',
    '1609092': u'Popielów',
    '2406072': u'Popów',
    '2409042': u'Poraj',
    '2402082': u'Porąbka',
    '2416011': u'Poręba',
    '1217052': u'Poronin',
    '3213052': u'Postomino',
    '1007062': u'Poświętne',
    '1434082': u'Poświętne',
    '2002082': u'Poświętne',
    '2212072': u'Potęgowo',
    '0602112': u'Potok Górny',
    '0605072': u'Potok Wielki',
    '1423052': u'Potworów',
    '3023052': u'Powidz',
    '2819022': u'Pozezdrze',
    '3064029': u'Poznań-Grunwald',
    '3064039': u'Poznań-Jeżyce',
    '3064049': u'Poznań-Nowe Miasto',
    '3064059': u'Poznań-Stare Miasto',
    '3064069': u'Poznań-Wilda',
    '2207043': u'Prabuty',
    '1465078': u'Praga-Południe',
    '1465088': u'Praga-Północ',
    '1608043': u'Praszka',
    '1418052': u'Prażmów',
    '0209073': u'Prochowice',
    '1401022': u'Promna',
    '2805042': u'Prostki',
    '1214053': u'Proszowice',
    '1609103': u'Prószków',
    '1804072': u'Pruchnik',
    '1610043': u'Prudnik',
    '0220023': u'Prusice',
    '0414082': u'Pruszcz',
    '2204011': u'Pruszcz Gdański',
    '2204042': u'Pruszcz Gdański',
    '1421021': u'Pruszków',
    '1422011': u'Przasnysz',
    '1422072': u'Przasnysz',
    '2203062': u'Przechlewo',
    '1213082': u'Przeciszów',
    '1811072': u'Przecław',
    '1012113': u'Przedbórz',
    '3009113': u'Przedecz',
    '3212042': u'Przelewice',
    '3029012': u'Przemęt',
    '0216053': u'Przemków',
    '1813082': u'Przemyśl',
    '2012042': u'Przerośl',
    '1426072': u'Przesmyki',
    '0217032': u'Przeworno',
    '1814011': u'Przeworsk',
    '1814062': u'Przeworsk',
    '0811072': u'Przewóz',
    '2205032': u'Przodkowo',
    '3204062': u'Przybiernów',
    '3017052': u'Przygodzice',
    '3027062': u'Przykona',
    '1436032': u'Przyłęk',
    '2404142': u'Przyrów',
    '2406082': u'Przystajń',
    '1423063': u'Przysucha',
    '0803032': u'Przytoczna',
    '2007062': u'Przytuły',
    '1425092': u'Przytyk',
    '2204052': u'Przywidz',
    '2401062': u'Psary',
    '0803042': u'Pszczew',
    '2204062': u'Pszczółki',
    '2410053': u'Pszczyna',
    '2415011': u'Pszów',
    '0610052': u'Puchaczów',
    '2211031': u'Puck',
    '2211072': u'Puck',
    '0614011': u'Puławy',
    '0614092': u'Puławy',
    '1424043': u'Pułtusk',
    '2009042': u'Puńsk',
    '2814102': u'Purda',
    '1438032': u'Puszcza Mariańska',
    '3021021': u'Puszczykowo',
    '3212053': u'Pyrzyce',
    '2405021': u'Pyskowice',
    '1818032': u'Pysznica',
    '3030043': u'Pyzdry',
    '1211112': u'Raba Wyżna',
    '1211123': u'Rabka-Zdrój',
    '0618072': u'Rachanie',
    '1420021': u'Raciąż',
    '1420102': u'Raciąż',
    '0401072': u'Raciążek',
    '2411011': u'Racibórz',
    '1209052': u'Raciechowice',
    '1208062': u'Racławice',
    '2012052': u'Raczki',
    '0620082': u'Radecznica',
    '1204062': u'Radgoszcz',
    '0208123': u'Radków',
    '2613042': u'Radków',
    '2415021': u'Radlin',
    '1216052': u'Radłów',
    '1608052': u'Radłów',
    '0405052': u'Radomin',
    '1012011': u'Radomsko',
    '1012122': u'Radomsko',
    '1818042': u'Radomyśl nad Sanem',
    '1811083': u'Radomyśl Wielki',
    '2605042': u'Radoszyce',
    '3218032': u'Radowo Małe',
    '0216062': u'Radwanice',
    '1804021': u'Radymno',
    '1804082': u'Radymno',
    '1419102': u'Radzanowo',
    '1401032': u'Radzanów',
    '1413042': u'Radzanów',
    '2417102': u'Radziechowy-Wieprz',
    '1438042': u'Radziejowice',
    '0411011': u'Radziejów',
    '0411062': u'Radziejów',
    '1214062': u'Radziemice',
    '2004032': u'Radziłów',
    '2413031': u'Radzionków',
    '1434093': u'Radzymin',
    '0406043': u'Radzyń Chełmiński',
    '0615011': u'Radzyń Podlaski',
    '0615062': u'Radzyń Podlaski',
    '2417112': u'Rajcza',
    '2004043': u'Rajgród',
    '3005043': u'Rakoniewice',
    '2604162': u'Raków',
    '1810062': u'Rakszawa',
    '1806052': u'Raniżów',
    '3017063': u'Raszków',
    '1421062': u'Raszyn',
    '1013011': u'Rawa Mazowiecka',
    '1013042': u'Rawa Mazowiecka',
    '3022053': u'Rawicz',
    '3216042': u'Rąbino',
    '3202063': u'Recz',
    '2215011': u'Reda',
    '1402082': u'Regimin',
    '1013052': u'Regnów',
    '0606082': u'Rejowiec',
    '0603011': u'Rejowiec Fabryczny',
    '0603082': u'Rejowiec Fabryczny',
    '1465098': u'Rembertów',
    '1603062': u'Reńska Wieś',
    '1429062': u'Repki',
    '3218043': u'Resko',
    '2808053': u'Reszel',
    '3205072': u'Rewal',
    '1010072': u'Ręczno',
    '2404152': u'Rędziny',
    '0412032': u'Rogowo',
    '0419052': u'Rogowo',
    '3016023': u'Rogoźno',
    '1021052': u'Rogów',
    '0406052': u'Rogóźno',
    '0407082': u'Rojewo',
    '1016072': u'Rokiciny',
    '1804092': u'Rokietnica',
    '3021132': u'Rokietnica',
    '0601122': u'Rokitno',
    '1205082': u'Ropa',
    '1815033': u'Ropczyce',
    '0601132': u'Rossosz',
    '1427042': u'Rościszewo',
    '3012052': u'Rozdrażew',
    '2817052': u'Rozogi',
    '1010082': u'Rozprza',
    '1804102': u'Roźwienica',
    '1411073': u'Różan',
    '2816043': u'Ruciane-Nida',
    '0603092': u'Ruda-Huta',
    '2605052': u'Ruda Maleniecka',
    '2003072': u'Rudka',
    '0211032': u'Rudna',
    '0606092': u'Rudnik',
    '2411082': u'Rudnik',
    '1608062': u'Rudniki',
    '1812063': u'Rudnik nad Sanem',
    '2405052': u'Rudziniec',
    '0209082': u'Ruja',
    '2215021': u'Rumia',
    '1001062': u'Rusiec',
    '1423072': u'Rusinów',
    '2012062': u'Rutka-Tartak',
    '2014032': u'Rutki',
    '0617042': u'Rybczewice',
    '1428062': u'Rybno',
    '2803062': u'Rybno',
    '2804082': u'Rychliki',
    '3008062': u'Rychtal',
    '3010073': u'Rychwał',
    '3016032': u'Ryczywół',
    '2415031': u'Rydułtowy',
    '3013043': u'Rydzyna',
    '1216063': u'Ryglice',
    '2207052': u'Ryjewo',
    '0616043': u'Ryki',
    '1807083': u'Rymanów',
    '3208052': u'Rymań',
    '2806083': u'Ryn',
    '0412011': u'Rypin',
    '0412042': u'Rypin',
    '1210152': u'Rytro',
    '2612062': u'Rytwiany',
    '1009052': u'Rząśnia',
    '1435032': u'Rząśnik',
    '2203072': u'Rzeczenica',
    '1409042': u'Rzeczniów',
    '1016082': u'Rzeczyca',
    '1415102': u'Rzekuń',
    '1216072': u'Rzepiennik Strzyżewski',
    '0805043': u'Rzepin',
    '1411082': u'Rzewnie',
    '1201072': u'Rzezawa',
    '1006102': u'Rzgów',
    '3010082': u'Rzgów',
    '1429072': u'Sabnie',
    '0410042': u'Sadki',
    '1013062': u'Sadkowice',
    '2207062': u'Sadlinki',
    '2606062': u'Sadowie',
    '1433072': u'Sadowne',
    '2609072': u'Samborzec',
    '2609011': u'Sandomierz',
    '1404042': u'Sanniki',
    '1817011': u'Sanok',
    '1817052': u'Sanok',
    '0801062': u'Santok',
    '1410052': u'Sarnaki',
    '0603102': u'Sawin',
    '2613052': u'Secemin',
    '2009011': u'Sejny',
    '2009052': u'Sejny',
    '0608122': u'Serniki',
    '1408043': u'Serock',
    '0611062': u'Serokomla',
    '1003032': u'Sędziejowice',
    '2602063': u'Sędziszów',
    '1815043': u'Sędziszów Małopolski',
    '1205092': u'Sękowa',
    '2801063': u'Sępopol',
    '0413023': u'Sępólno Krajeńskie',
    '3209073': u'Sianów',
    '0403072': u'Sicienko',
    '2011072': u'Sidra',
    '1407072': u'Sieciechów',
    '1426082': u'Siedlce',
    '3029022': u'Siedlec',
    '0804082': u'Siedlisko',
    '0603112': u'Siedliszcze',
    '0210072': u'Siekierczyn',
    '2010011': u'Siemiatycze',
    '2010092': u'Siemiatycze',
    '1437052': u'Siemiątkowo',
    '0613062': u'Siemień',
    '1009062': u'Siemkowice',
    '3208062': u'Siemyśl',
    '1814073': u'Sieniawa',
    '1412132': u'Siennica',
    '0606102': u'Siennica Różana',
    '1409052': u'Sienno',
    '1209062': u'Siepraw',
    '1014011': u'Sieradz',
    '1014082': u'Sieradz',
    '2205042': u'Sierakowice',
    '3014043': u'Sieraków',
    '3017072': u'Sieroszewice',
    '1427011': u'Sierpc',
    '1427052': u'Sierpc',
    '2401073': u'Siewierz',
    '2604172': u'Sitkówka-Nowiny',
    '0620092': u'Sitno',
    '2603053': u'Skalbmierz',
    '1206103': u'Skała',
    '1601022': u'Skarbimierz',
    '2213093': u'Skarszewy',
    '1425103': u'Skaryszew',
    '2610011': u'Skarżysko-Kamienna',
    '2610042': u'Skarżysko Kościelne',
    '1206113': u'Skawina',
    '0808032': u'Skąpe',
    '0408073': u'Skępe',
    '0620102': u'Skierbieszów',
    '1015082': u'Skierniewice',
    '2403103': u'Skoczów',
    '3028053': u'Skoki',
    '1805092': u'Skołyszyn',
    '1017082': u'Skomlin',
    '1607092': u'Skoroszyce',
    '2213021': u'Skórcz',
    '2213102': u'Skórcz',
    '1426092': u'Skórzec',
    '0412052': u'Skrwilno',
    '1216082': u'Skrzyszów',
    '3010092': u'Skulsk',
    '0803053': u'Skwierzyna',
    '1208072': u'Słaboszów',
    '0812013': u'Sława',
    '0601142': u'Sławatycze',
    '2401081': u'Sławków',
    '1007072': u'Sławno',
    '3213021': u'Sławno',
    '3213062': u'Sławno',
    '3216052': u'Sławoborze',
    '1206123': u'Słomniki',
    '0807032': u'Słońsk',
    '1207112': u'Słopnice',
    '0805053': u'Słubice',
    '1419112': u'Słubice',
    '3023011': u'Słupca',
    '3023062': u'Słupca',
    '1015092': u'Słupia',
    '2602072': u'Słupia (Jędrzejowska)',
    '2605062': u'Słupia (Konecka)',
    '1419122': u'Słupno',
    '2212082': u'Słupsk',
    '2213112': u'Smętowo Graniczne',
    '2212092': u'Smołdzino',
    '2605072': u'Smyków',
    '1417072': u'Sobienie-Jeziory',
    '2602082': u'Sobków',
    '1403112': u'Sobolew',
    '0223073': u'Sobótka',
    '1428011': u'Sochaczew',
    '1428072': u'Sochaczew',
    '1420112': u'Sochocin',
    '1018062': u'Sokolniki',
    '1816113': u'Sokołów Małopolski',
    '1429011': u'Sokołów Podlaski',
    '1429082': u'Sokołów Podlaski',
    '2013082': u'Sokoły',
    '2011083': u'Sokółka',
    '0403083': u'Solec Kujawski',
    '1409062': u'Solec nad Wisłą',
    '2601052': u'Solec-Zdrój',
    '1821052': u'Solina',
    '1435042': u'Somianka',
    '2205052': u'Somonino',
    '3010103': u'Sompolno',
    '1402092': u'Sońsk',
    '2810052': u'Sorkwity',
    '0613072': u'Sosnowica',
    '0601152': u'Sosnówka',
    '2405063': u'Sośnicowice',
    '3017082': u'Sośnie',
    '0413032': u'Sośno',
    '0610062': u'Spiczyn',
    '1211132': u'Spytkowice',
    '1218062': u'Spytkowice',
    '2808062': u'Srokowo',
    '1818011': u'Stalowa Wola',
    '0611072': u'Stanin',
    '1412142': u'Stanisławów',
    '1419132': u'Stara Biała',
    '1401042': u'Stara Błotnica',
    '2611011': u'Starachowice',
    '3214092': u'Stara Dąbrowa',
    '0206092': u'Stara Kamienica',
    '2206082': u'Stara Kiszewa',
    '1410062': u'Stara Kornica',
    '2404162': u'Starcza',
    '1432072': u'Stare Babice',
    '0221072': u'Stare Bogaczowice',
    '3206072': u'Stare Czarnowo',
    '2805052': u'Stare Juchy',
    '0806032': u'Stare Kurowo',
    '3010112': u'Stare Miasto',
    '2209082': u'Stare Pole',
    '3214011': u'Stargard Szczeciński',
    '3214102': u'Stargard Szczeciński',
    '2213031': u'Starogard Gdański',
    '2213122': u'Starogard Gdański',
    '1419142': u'Staroźreby',
    '0619042': u'Stary Brus',
    '2216032': u'Stary Dzierzgoń',
    '1809072': u'Stary Dzików',
    '1416082': u'Stary Lubotyń',
    '1210163': u'Stary Sącz',
    '2216042': u'Stary Targ',
    '0620112': u'Stary Zamość',
    '2612073': u'Staszów',
    '2814112': u'Stawiguda',
    '2006053': u'Stawiski',
    '3007093': u'Stawiszyn',
    '2605083': u'Stąporków',
    '2210042': u'Stegna',
    '3204072': u'Stepnica',
    '1429092': u'Sterdyń',
    '3021143': u'Stęszew',
    '0616052': u'Stężyca',
    '2205062': u'Stężyca',
    '1433082': u'Stoczek',
    '0611021': u'Stoczek Łukowski',
    '0611082': u'Stoczek Łukowski',
    '0404062': u'Stolno',
    '2601062': u'Stopnica',
    '0224042': u'Stoszowice',
    '1434102': u'Strachówka',
    '2604182': u'Strawczyn',
    '1401052': u'Stromiec',
    '0208133': u'Stronie Śląskie',
    '2403113': u'Strumień',
    '1020083': u'Stryków',
    '1215072': u'Stryszawa',
    '1218072': u'Stryszów',
    '3023072': u'Strzałkowo',
    '0219063': u'Strzegom',
    '1413052': u'Strzegowo',
    '1002102': u'Strzelce',
    '0806043': u'Strzelce Krajeńskie',
    '1611053': u'Strzelce Opolskie',
    '1009072': u'Strzelce Wielkie',
    '1605032': u'Strzeleczki',
    '0217043': u'Strzelin',
    '0409043': u'Strzelno',
    '0609122': u'Strzyżewice',
    '1819043': u'Strzyżów',
    '1813092': u'Stubno',
    '2201082': u'Studzienice',
    '1413062': u'Stupsk',
    '2214052': u'Subkowy',
    '1215021': u'Sucha Beskidzka',
    '3214113': u'Suchań',
    '2610053': u'Suchedniów',
    '2011093': u'Suchowola',
    '1426102': u'Suchożebry',
    '2204072': u'Suchy Dąb',
    '3021152': u'Suchy Las',
    '0809063': u'Sulechów',
    '1010093': u'Sulejów',
    '1412151': u'Sulejówek',
    '0807043': u'Sulęcin',
    '2205072': u'Sulęczyno',
    '0225052': u'Sulików',
    '1009082': u'Sulmierzyce',
    '3012011': u'Sulmierzyce',
    '1209073': u'Sułkowice',
    '1206132': u'Sułoszowa',
    '0620122': u'Sułów',
    '2002093': u'Supraśl',
    '2002103': u'Suraż',
    '0618082': u'Susiec',
    '2807063': u'Susz',
    '2410062': u'Suszec',
    '2012072': u'Suwałki',
    '3021163': u'Swarzędz',
    '0214073': u'Syców',
    '1411092': u'Sypniewo',
    '1019023': u'Szadek',
    '1211142': u'Szaflary',
    '3001053': u'Szamocin',
    '3024073': u'Szamotuły',
    '0607062': u'Szastarka',
    '0808042': u'Szczaniec',
    '1404052': u'Szczawin Kościelny',
    '1211021': u'Szczawnica',
    '0221031': u'Szczawno-Zdrój',
    '0620133': u'Szczebrzeszyn',
    '3215011': u'Szczecinek',
    '3215062': u'Szczecinek',
    '2416083': u'Szczekociny',
    '1001072': u'Szczerców',
    '1204072': u'Szczucin',
    '2004053': u'Szczuczyn',
    '1202072': u'Szczurowa',
    '1427062': u'Szczutowo',
    '2402011': u'Szczyrk',
    '0208143': u'Szczytna',
    '3007102': u'Szczytniki',
    '2817011': u'Szczytno',
    '2817062': u'Szczytno',
    '1411102': u'Szelków',
    '2215092': u'Szemud',
    '2013092': u'Szepietowo',
    '1216162': u'Szerzyny',
    '0206041': u'Szklarska Poręba',
    '0812023': u'Szlichtyngowa',
    '0810073': u'Szprotawa',
    '1413072': u'Szreńsk',
    '2001072': u'Sztabin',
    '2216053': u'Sztum',
    '2210052': u'Sztutowo',
    '0410053': u'Szubin',
    '2011102': u'Szudziałowo',
    '1416092': u'Szulborze Wielkie',
    '2014042': u'Szumowo',
    '1430053': u'Szydłowiec',
    '1413082': u'Szydłowo',
    '3019062': u'Szydłowo',
    '2612082': u'Szydłów',
    '2012082': u'Szypliszki',
    '0211043': u'Ścinawa',
    '2417122': u'Ślemień',
    '3010123': u'Ślesin',
    '0416052': u'Śliwice',
    '3011053': u'Śmigiel',
    '2007072': u'Śniadowo',
    '3026043': u'Śrem',
    '0218043': u'Środa Śląska',
    '3025043': u'Środa Wielkopolska',
    '1465108': u'Śródmieście',
    '2814122': u'Świątki',
    '1206143': u'Świątniki Górne',
    '0219011': u'Świdnica',
    '0219072': u'Świdnica',
    '0809072': u'Świdnica',
    '0617011': u'Świdnik',
    '3216011': u'Świdwin',
    '3216062': u'Świdwin',
    '0219021': u'Świebodzice',
    '0808053': u'Świebodzin',
    '0414093': u'Świecie',
    '0406062': u'Świecie nad Osą',
    '0402092': u'Świedziebnia',
    '0414102': u'Świekatowo',
    '0210021': u'Świeradów-Zdrój',
    '1424052': u'Świercze',
    '1606042': u'Świerczów',
    '2413072': u'Świerklaniec',
    '2412052': u'Świerklany',
    '0226043': u'Świerzawa',
    '3207052': u'Świerzno',
    '3209082': u'Świeszyno',
    '3013052': u'Święciechowa',
    '2813052': u'Świętajno',
    '2817072': u'Świętajno',
    '0223083': u'Święta Katarzyna',
    '1816122': u'Świlcza',
    '1004072': u'Świnice Warckie',
    '2417132': u'Świnna',
    '1418063': u'Tarczyn',
    '1465118': u'Targówek',
    '2606072': u'Tarłów',
    '0618092': u'Tarnawatka',
    '0602123': u'Tarnogród',
    '1805112': u'Tarnowiec',
    '3021172': u'Tarnowo Podgórne',
    '2413041': u'Tarnowskie Góry',
    '1216092': u'Tarnów',
    '3031062': u'Tarnówka',
    '1609112': u'Tarnów Opolski',
    '2214011': u'Tczew',
    '2214062': u'Tczew',
    '1436042': u'Tczów',
    '0618102': u'Telatyn',
    '1428082': u'Teresin',
    '0601021': u'Terespol',
    '0601162': u'Terespol',
    '0602132': u'Tereszpol',
    '0408082': u'Tłuchowo',
    '1434113': u'Tłuszcz',
    '1209082': u'Tokarnia',
    '2804093': u'Tolkmicko',
    '0618011': u'Tomaszów Lubelski',
    '0618112': u'Tomaszów Lubelski',
    '1016011': u'Tomaszów Mazowiecki',
    '1016092': u'Tomaszów Mazowiecki',
    '1218082': u'Tomice',
    '0411072': u'Topólka',
    '0807053': u'Torzym',
    '2405073': u'Toszek',
    '0617052': u'Trawniki',
    '2204082': u'Trąbki Wielkie',
    '1403122': u'Trojanów',
    '1415112': u'Troszyn',
    '1814082': u'Tryńcza',
    '1201082': u'Trzciana',
    '3002073': u'Trzcianka',
    '2008072': u'Trzcianne',
    '0803063': u'Trzciel',
    '3008072': u'Trzcinica',
    '3206083': u'Trzcińsko-Zdrój',
    '3205083': u'Trzebiatów',
    '0809082': u'Trzebiechów',
    '0811082': u'Trzebiel',
    '2201092': u'Trzebielino',
    '0611092': u'Trzebieszów',
    '1203053': u'Trzebinia',
    '0220033': u'Trzebnica',
    '1816132': u'Trzebownisko',
    '3003093': u'Trzemeszno',
    '0604062': u'Trzeszczany',
    '1212062': u'Trzyciąż',
    '0607072': u'Trzydnik Duży',
    '0416063': u'Tuchola',
    '2201102': u'Tuchomie',
    '1216103': u'Tuchów',
    '2601072': u'Tuczępy',
    '0601172': u'Tuczna',
    '3217043': u'Tuczno',
    '3027073': u'Tuliszków',
    '1609122': u'Tułowice',
    '0811092': u'Tuplice',
    '1609132': u'Turawa',
    '3027011': u'Turek',
    '3027082': u'Turek',
    '0602142': u'Turobin',
    '2006062': u'Turośl',
    '2002112': u'Turośń Kościelna',
    '1811092': u'Tuszów Narodowy',
    '1006113': u'Tuszyn',
    '0214083': u'Twardogóra',
    '2413082': u'Tworóg',
    '3201042': u'Tychowo',
    '1816143': u'Tyczyn',
    '2002123': u'Tykocin',
    '1207122': u'Tymbark',
    '1817062': u'Tyrawa Wołoska',
    '0618123': u'Tyszowce',
    '0604072': u'Uchanie',
    '0218052': u'Udanin',
    '1016102': u'Ujazd',
    '1611063': u'Ujazd',
    '2417142': u'Ujsoły',
    '3019073': u'Ujście',
    '0615072': u'Ulan-Majorat',
    '1812073': u'Ulanów',
    '0618132': u'Ulhówek',
    '0616062': u'Ułęż',
    '1011043': u'Uniejów',
    '0404072': u'Unisław',
    '1465128': u'Ursus',
    '1465138': u'Ursynów',
    '0619052': u'Urszulin',
    '0607082': u'Urzędów',
    '2212011': u'Ustka',
    '2212102': u'Ustka',
    '3208072': u'Ustronie Morskie',
    '2403021': u'Ustroń',
    '1801083': u'Ustrzyki Dolne',
    '1205102': u'Uście Gorlickie',
    '0608132': u'Uścimów',
    '1218093': u'Wadowice',
    '1811102': u'Wadowice Górne',
    '0401082': u'Waganiec',
    '1605042': u'Walce',
    '0221082': u'Walim',
    '0221091': u'Wałbrzych',
    '3217011': u'Wałcz',
    '3217052': u'Wałcz',
    '3028062': u'Wapno',
    '1406113': u'Warka',
    '0414112': u'Warlubie',
    '3212062': u'Warnice',
    '1014093': u'Warta',
    '0201062': u'Warta Bolesławiecka',
    '1011052': u'Wartkowice',
    '2002133': u'Wasilków',
    '2607062': u'Waśniów',
    '1465148': u'Wawer',
    '0417011': u'Wąbrzeźno',
    '0417052': u'Wąbrzeźno',
    '2611053': u'Wąchock',
    '0205062': u'Wądroże Wielkie',
    '3028011': u'Wągrowiec',
    '3028072': u'Wągrowiec',
    '0412062': u'Wąpielsk',
    '1416102': u'Wąsewo',
    '0204043': u'Wąsosz',
    '2004062': u'Wąsosz',
    '0614102': u'Wąwolnica',
    '2215031': u'Wejherowo',
    '2215102': u'Wejherowo',
    '0604082': u'Werbkowice',
    '1465158': u'Wesoła',
    '2417152': u'Węgierska Górka',
    '0225063': u'Węgliniec',
    '2819033': u'Węgorzewo',
    '3218053': u'Węgorzyno',
    '1433011': u'Węgrów',
    '1417082': u'Wiązowna',
    '1804112': u'Wiązownica',
    '0217053': u'Wiązów',
    '2208052': u'Wicko',
    '1003042': u'Widawa',
    '3206092': u'Widuchowa',
    '1413092': u'Wieczfnia Kościelna',
    '2817082': u'Wielbark',
    '3002083': u'Wieleń',
    '0408092': u'Wielgie',
    '1012132': u'Wielgomłyny',
    '3005053': u'Wielichowo',
    '1219053': u'Wieliczka',
    '2813062': u'Wieliczki',
    '1408052': u'Wieliszew',
    '0415082': u'Wielka Nieszawka',
    '1206152': u'Wielka Wieś',
    '1809082': u'Wielkie Oczy',
    '1815052': u'Wielopole Skrzyńskie',
    '2405082': u'Wielowieś',
    '1017093': u'Wieluń',
    '1423082': u'Wieniawa',
    '1218102': u'Wieprz',
    '1018073': u'Wieruszów',
    '0603122': u'Wierzbica',
    '1425112': u'Wierzbica',
    '3010132': u'Wierzbinek',
    '1433092': u'Wierzbno',
    '1017102': u'Wierzchlas',
    '1216112': u'Wierzchosławice',
    '3203052': u'Wierzchowo',
    '1216122': u'Wietrzychowice',
    '0413043': u'Więcbork',
    '3013062': u'Wijewo',
    '2402093': u'Wilamowice',
    '1465168': u'Wilanów',
    '2802072': u'Wilczęta',
    '2609082': u'Wilczyce',
    '3010142': u'Wilczyn',
    '1403132': u'Wilga',
    '0607092': u'Wilkołaz',
    '2402102': u'Wilkowice',
    '0612072': u'Wilków',
    '1606052': u'Wilków',
    '1424062': u'Winnica',
    '0222022': u'Wińsko',
    '1438052': u'Wiskitki',
    '2403031': u'Wisła',
    '0220042': u'Wisznia Mała',
    '0601182': u'Wisznice',
    '2601082': u'Wiślica',
    '1426112': u'Wiśniew',
    '1413102': u'Wiśniewo',
    '1209092': u'Wiśniowa',
    '1819052': u'Wiśniowa',
    '3003103': u'Witkowo',
    '0801073': u'Witnica',
    '1004082': u'Witonia',
    '2007082': u'Wizna',
    '2012092': u'Wiżajny',
    '0212053': u'Wleń',
    '2211041': u'Władysławowo',
    '3027092': u'Władysławów',
    '1465178': u'Włochy',
    '0418132': u'Włocławek',
    '0619011': u'Włodawa',
    '0619062': u'Włodawa',
    '2416092': u'Włodowice',
    '3013072': u'Włoszakowice',
    '2613063': u'Włoszczowa',
    '1426122': u'Wodynie',
    '1003052': u'Wodzierady',
    '2602092': u'Wodzisław',
    '2415041': u'Wodzisław Śląski',
    '0615082': u'Wohyń',
    '1807092': u'Wojaszówka',
    '2606082': u'Wojciechowice',
    '0609132': u'Wojciechów',
    '0611102': u'Wojcieszków',
    '0226011': u'Wojcieszów',
    '2401031': u'Wojkowice',
    '1216132': u'Wojnicz',
    '0603132': u'Wojsławice',
    '1465188': u'Wola',
    '1010102': u'Wola Krzysztoporska',
    '0611112': u'Wola Mysłowska',
    '1425122': u'Wolanów',
    '0619072': u'Wola Uhruska',
    '1010112': u'Wolbórz',
    '1212073': u'Wolbrom',
    '3207063': u'Wolin',
    '3029033': u'Wolsztyn',
    '1604043': u'Wołczyn',
    '1434123': u'Wołomin',
    '0222033': u'Wołów',
    '2407083': u'Woźniki',
    '0609142': u'Wólka',
    '2406092': u'Wręczyca Wielka',
    '0264029': u'Wrocław-Fabryczna',
    '0264039': u'Wrocław-Krzyki',
    '0264049': u'Wrocław-Psie Pole',
    '0264059': u'Wrocław-Stare Miasto',
    '0264069': u'Wrocław-Śródmieście',
    '3024083': u'Wronki',
    '1014102': u'Wróblew',
    '3030053': u'Września',
    '0812033': u'Wschowa',
    '2806102': u'Wydminy',
    '0810082': u'Wymiarki',
    '2408052': u'Wyry',
    '0619082': u'Wyryki',
    '3019083': u'Wyrzysk',
    '3019093': u'Wysoka',
    '0609152': u'Wysokie',
    '2013011': u'Wysokie Mazowieckie',
    '2013102': u'Wysokie Mazowieckie',
    '2003082': u'Wyszki',
    '1435053': u'Wyszków',
    '1419153': u'Wyszogród',
    '1401063': u'Wyśmierzyce',
    '1206162': u'Zabierzów',
    '2002143': u'Zabłudów',
    '0809092': u'Zabór',
    '1435062': u'Zabrodzie',
    '1011062': u'Zadzim',
    '2604192': u'Zagnańsk',
    '3023083': u'Zagórów',
    '1817073': u'Zagórz',
    '0226052': u'Zagrodno',
    '1216142': u'Zakliczyn',
    '1818052': u'Zaklików',
    '1217011': u'Zakopane',
    '1414063': u'Zakroczym',
    '0609162': u'Zakrzew',
    '1425132': u'Zakrzew',
    '0401092': u'Zakrzewo',
    '3031072': u'Zakrzewo',
    '0607102': u'Zakrzówek',
    '0601192': u'Zalesie',
    '1818062': u'Zaleszany',
    '2807073': u'Zalewo',
    '1420122': u'Załuski',
    '2014011': u'Zambrów',
    '2014052': u'Zambrów',
    '0620142': u'Zamość',
    '3025052': u'Zaniemyśl',
    '1019032': u'Zapolice',
    '1416112': u'Zaręby Kościelne',
    '1817082': u'Zarszyn',
    '1814092': u'Zarzecze',
    '1213093': u'Zator',
    '1424072': u'Zatory',
    '2002152': u'Zawady',
    '1611073': u'Zawadzkie',
    '2609093': u'Zawichost',
    '0225011': u'Zawidów',
    '1427072': u'Zawidz',
    '2416021': u'Zawiercie',
    '1215082': u'Zawoja',
    '0220052': u'Zawonia',
    '1434031': u'Ząbki',
    '0224053': u'Ząbkowice Śląskie',
    '0808063': u'Zbąszynek',
    '3015063': u'Zbąszyń',
    '0402102': u'Zbiczno',
    '2213132': u'Zblewo',
    '2007092': u'Zbójna',
    '0405062': u'Zbójno',
    '2413092': u'Zbrosławice',
    '1426132': u'Zbuczyn',
    '1005102': u'Zduny',
    '3012063': u'Zduny',
    '1019011': u'Zduńska Wola',
    '1019042': u'Zduńska Wola',
    '1605053': u'Zdzieszowice',
    '2403122': u'Zebrzydowice',
    '1001083': u'Zelów',
    '1215092': u'Zembrzyce',
    '1608072': u'Zębowice',
    '1020031': u'Zgierz',
    '1020092': u'Zgierz',
    '0225021': u'Zgorzelec',
    '0225072': u'Zgorzelec',
    '0809102': u'Zielona Góra',
    '1434041': u'Zielonka',
    '1206172': u'Zielonki',
    '0224063': u'Ziębice',
    '0415092': u'Zławieś Wielka',
    '3203063': u'Złocieniec',
    '1014113': u'Złoczew',
    '2608052': u'Złota',
    '0407092': u'Złotniki Kujawskie',
    '0226021': u'Złotoryja',
    '0226062': u'Złotoryja',
    '3031011': u'Złotów',
    '3031082': u'Złotów',
    '0224073': u'Złoty Stok',
    '0806052': u'Zwierzyn',
    '0620153': u'Zwierzyniec',
    '1436053': u'Zwoleń',
    '1405062': u'Żabia Wola',
    '1216153': u'Żabno',
    '0810021': u'Żagań',
    '0810092': u'Żagań',
    '2409053': u'Żarki',
    '2416102': u'Żarnowiec',
    '1007082': u'Żarnów',
    '0219083': u'Żarów',
    '0811021': u'Żary',
    '0811102': u'Żary',
    '1201092': u'Żegocina',
    '3007112': u'Żelazków',
    '1016112': u'Żelechlinek',
    '1403143': u'Żelechów',
    '3006043': u'Żerków',
    '0220063': u'Żmigród',
    '0603142': u'Żmudź',
    '0419063': u'Żnin',
    '1465198': u'Żoliborz',
    '1810072': u'Żołynia',
    '0606112': u'Żółkiewka',
    '0223092': u'Żórawina',
    '0203062': u'Żukowice',
    '2205083': u'Żukowo',
    '1813102': u'Żurawica',
    '1437063': u'Żuromin',
    '1002113': u'Żychlin',
    '1803072': u'Żyraków',
    '1438011': u'Żyrardów',
    '0614112': u'Żyrzyn',
    '1012142': u'Żytno',
    '2417011': u'Żywiec',
}
