# -*- coding: utf-8 -*-
'''
Dictionaries containing TERYT code and names of corresponding administrative
entities.

Provinces are also known as voivodships, counties as poviats.

Source: http://www.stat.gov.pl/broker/access/prefile/downloadPreFile.jspa?id=68
'''

from django.utils.translation import ugettext_lazy

PL_PROVINCES = {
    '02': ugettext_lazy(u'dolnośląskie'),
    '04': ugettext_lazy(u'kujawsko-pomorskie'),
    '06': ugettext_lazy(u'lubelskie'),
    '08': ugettext_lazy(u'lubuskie'),
    '10': ugettext_lazy(u'łódzkie'),
    '12': ugettext_lazy(u'małopolskie'),
    '14': ugettext_lazy(u'mazowieckie'),
    '16': ugettext_lazy(u'opolskie'),
    '18': ugettext_lazy(u'podkarpackie'),
    '20': ugettext_lazy(u'podlaskie'),
    '22': ugettext_lazy(u'pomorskie'),
    '24': ugettext_lazy(u'śląskie'),
    '26': ugettext_lazy(u'świętokrzyskie'),
    '28': ugettext_lazy(u'warmińsko-mazurskie'),
    '30': ugettext_lazy(u'wielkopolskie'),
    '32': ugettext_lazy(u'zachodniopomorskie'),
}

PL_COUNTIES = {
    '0201': u'bolesławiecki',
    '0202': u'dzierżoniowski',
    '0203': u'głogowski',
    '0204': u'górowski',
    '0205': u'jaworski',
    '0206': u'jeleniogórski',
    '0207': u'kamiennogórski',
    '0208': u'kłodzki',
    '0209': u'legnicki',
    '0210': u'lubański',
    '0211': u'lubiński',
    '0212': u'lwówecki',
    '0213': u'milicki',
    '0214': u'oleśnicki',
    '0215': u'oławski',
    '0216': u'polkowicki',
    '0217': u'strzeliński',
    '0218': u'średzki',
    '0219': u'świdnicki',
    '0220': u'trzebnicki',
    '0221': u'wałbrzyski',
    '0222': u'wołowski',
    '0223': u'wrocławski',
    '0224': u'ząbkowicki',
    '0225': u'zgorzelecki',
    '0226': u'złotoryjski',
    '0261': u'Jelenia Góra',
    '0262': u'Legnica',
    '0264': u'Wrocław',
    '0401': u'aleksandrowski',
    '0402': u'brodnicki',
    '0403': u'bydgoski',
    '0404': u'chełmiński',
    '0405': u'golubsko-dobrzyński',
    '0406': u'grudziądzki',
    '0407': u'inowrocławski',
    '0408': u'lipnowski',
    '0409': u'mogileński',
    '0410': u'nakielski',
    '0411': u'radziejowski',
    '0412': u'rypiński',
    '0413': u'sępoleński',
    '0414': u'świecki',
    '0415': u'toruński',
    '0416': u'tucholski',
    '0417': u'wąbrzeski',
    '0418': u'włocławski',
    '0419': u'żniński',
    '0461': u'Bydgoszcz',
    '0462': u'Grudziądz',
    '0463': u'Toruń',
    '0464': u'Włocławek',
    '0601': u'bialski',
    '0602': u'biłgorajski',
    '0603': u'chełmski',
    '0604': u'hrubieszowski',
    '0605': u'janowski',
    '0606': u'krasnostawski',
    '0607': u'kraśnicki',
    '0608': u'lubartowski',
    '0609': u'lubelski',
    '0610': u'łęczyński',
    '0611': u'łukowski',
    '0612': u'opolski',
    '0613': u'parczewski',
    '0614': u'puławski',
    '0615': u'radzyński',
    '0616': u'rycki',
    '0617': u'świdnicki',
    '0618': u'tomaszowski',
    '0619': u'włodawski',
    '0620': u'zamojski',
    '0661': u'Biała Podlaska',
    '0662': u'Chełm',
    '0663': u'Lublin',
    '0664': u'Zamość',
    '0801': u'gorzowski',
    '0802': u'krośnieński',
    '0803': u'międzyrzecki',
    '0804': u'nowosolski',
    '0805': u'słubicki',
    '0806': u'strzelecko-drezdenecki',
    '0807': u'sulęciński',
    '0808': u'świebodziński',
    '0809': u'zielonogórski',
    '0810': u'żagański',
    '0811': u'żarski',
    '0812': u'wschowski',
    '0861': u'Gorzów Wielkopolski',
    '0862': u'Zielona Góra',
    '1001': u'bełchatowski',
    '1002': u'kutnowski',
    '1003': u'łaski',
    '1004': u'łęczycki',
    '1005': u'łowicki',
    '1006': u'łódzki wschodni',
    '1007': u'opoczyński',
    '1008': u'pabianicki',
    '1009': u'pajęczański',
    '1010': u'piotrkowski',
    '1011': u'poddębicki',
    '1012': u'radomszczański',
    '1013': u'rawski',
    '1014': u'sieradzki',
    '1015': u'skierniewicki',
    '1016': u'tomaszowski',
    '1017': u'wieluński',
    '1018': u'wieruszowski',
    '1019': u'zduńskowolski',
    '1020': u'zgierski',
    '1021': u'brzeziński',
    '1061': u'Łódź',
    '1062': u'Piotrków Trybunalski',
    '1063': u'Skierniewice',
    '1201': u'bocheński',
    '1202': u'brzeski',
    '1203': u'chrzanowski',
    '1204': u'dąbrowski',
    '1205': u'gorlicki',
    '1206': u'krakowski',
    '1207': u'limanowski',
    '1208': u'miechowski',
    '1209': u'myślenicki',
    '1210': u'nowosądecki',
    '1211': u'nowotarski',
    '1212': u'olkuski',
    '1213': u'oświęcimski',
    '1214': u'proszowicki',
    '1215': u'suski',
    '1216': u'tarnowski',
    '1217': u'tatrzański',
    '1218': u'wadowicki',
    '1219': u'wielicki',
    '1261': u'Kraków',
    '1262': u'Nowy Sącz',
    '1263': u'Tarnów',
    '1401': u'białobrzeski',
    '1402': u'ciechanowski',
    '1403': u'garwoliński',
    '1404': u'gostyniński',
    '1405': u'grodziski',
    '1406': u'grójecki',
    '1407': u'kozienicki',
    '1408': u'legionowski',
    '1409': u'lipski',
    '1410': u'łosicki',
    '1411': u'makowski',
    '1412': u'miński',
    '1413': u'mławski',
    '1414': u'nowodworski',
    '1415': u'ostrołęcki',
    '1416': u'ostrowski',
    '1417': u'otwocki',
    '1418': u'piaseczyński',
    '1419': u'płocki',
    '1420': u'płoński',
    '1421': u'pruszkowski',
    '1422': u'przasnyski',
    '1423': u'przysuski',
    '1424': u'pułtuski',
    '1425': u'radomski',
    '1426': u'siedlecki',
    '1427': u'sierpecki',
    '1428': u'sochaczewski',
    '1429': u'sokołowski',
    '1430': u'szydłowiecki',
    '1432': u'warszawski zachodni',
    '1433': u'węgrowski',
    '1434': u'wołomiński',
    '1435': u'wyszkowski',
    '1436': u'zwoleński',
    '1437': u'żuromiński',
    '1438': u'żyrardowski',
    '1461': u'Ostrołęka',
    '1462': u'Płock',
    '1463': u'Radom',
    '1464': u'Siedlce',
    '1465': u'Warszawa',
    '1601': u'brzeski',
    '1602': u'głubczycki',
    '1603': u'kędzierzyńsko-kozielski',
    '1604': u'kluczborski',
    '1605': u'krapkowicki',
    '1606': u'namysłowski',
    '1607': u'nyski',
    '1608': u'oleski',
    '1609': u'opolski',
    '1610': u'prudnicki',
    '1611': u'strzelecki',
    '1661': u'Opole',
    '1801': u'bieszczadzki',
    '1802': u'brzozowski',
    '1803': u'dębicki',
    '1804': u'jarosławski',
    '1805': u'jasielski',
    '1806': u'kolbuszowski',
    '1807': u'krośnieński',
    '1808': u'leżajski',
    '1809': u'lubaczowski',
    '1810': u'łańcucki',
    '1811': u'mielecki',
    '1812': u'niżański',
    '1813': u'przemyski',
    '1814': u'przeworski',
    '1815': u'ropczycko-sędziszowski',
    '1816': u'rzeszowski',
    '1817': u'sanocki',
    '1818': u'stalowowolski',
    '1819': u'strzyżowski',
    '1820': u'tarnobrzeski',
    '1821': u'leski',
    '1861': u'Krosno',
    '1862': u'Przemyśl',
    '1863': u'Rzeszów',
    '1864': u'Tarnobrzeg',
    '2001': u'augustowski',
    '2002': u'białostocki',
    '2003': u'bielski',
    '2004': u'grajewski',
    '2005': u'hajnowski',
    '2006': u'kolneński',
    '2007': u'łomżyński',
    '2008': u'moniecki',
    '2009': u'sejneński',
    '2010': u'siemiatycki',
    '2011': u'sokólski',
    '2012': u'suwalski',
    '2013': u'wysokomazowiecki',
    '2014': u'zambrowski',
    '2061': u'Białystok',
    '2062': u'Łomża',
    '2063': u'Suwałki',
    '2201': u'bytowski',
    '2202': u'chojnicki',
    '2203': u'człuchowski',
    '2204': u'gdański',
    '2205': u'kartuski',
    '2206': u'kościerski',
    '2207': u'kwidzyński',
    '2208': u'lęborski',
    '2209': u'malborski',
    '2210': u'nowodworski',
    '2211': u'pucki',
    '2212': u'słupski',
    '2213': u'starogardzki',
    '2214': u'tczewski',
    '2215': u'wejherowski',
    '2216': u'sztumski',
    '2261': u'Gdańsk',
    '2262': u'Gdynia',
    '2263': u'Słupsk',
    '2264': u'Sopot',
    '2401': u'będziński',
    '2402': u'bielski',
    '2403': u'cieszyński',
    '2404': u'częstochowski',
    '2405': u'gliwicki',
    '2406': u'kłobucki',
    '2407': u'lubliniecki',
    '2408': u'mikołowski',
    '2409': u'myszkowski',
    '2410': u'pszczyński',
    '2411': u'raciborski',
    '2412': u'rybnicki',
    '2413': u'tarnogórski',
    '2414': u'bieruńsko-lędziński',
    '2415': u'wodzisławski',
    '2416': u'zawierciański',
    '2417': u'żywiecki',
    '2461': u'Bielsko-Biała',
    '2462': u'Bytom',
    '2463': u'Chorzów',
    '2464': u'Częstochowa',
    '2465': u'Dąbrowa Górnicza',
    '2466': u'Gliwice',
    '2467': u'Jastrzębie-Zdrój',
    '2468': u'Jaworzno',
    '2469': u'Katowice',
    '2470': u'Mysłowice',
    '2471': u'Piekary Śląskie',
    '2472': u'Ruda Śląska',
    '2473': u'Rybnik',
    '2474': u'Siemianowice Śląskie',
    '2475': u'Sosnowiec',
    '2476': u'Świętochłowice',
    '2477': u'Tychy',
    '2478': u'Zabrze',
    '2479': u'Żory',
    '2601': u'buski',
    '2602': u'jędrzejowski',
    '2603': u'kazimierski',
    '2604': u'kielecki',
    '2605': u'konecki',
    '2606': u'opatowski',
    '2607': u'ostrowiecki',
    '2608': u'pińczowski',
    '2609': u'sandomierski',
    '2610': u'skarżyski',
    '2611': u'starachowicki',
    '2612': u'staszowski',
    '2613': u'włoszczowski',
    '2661': u'Kielce',
    '2801': u'bartoszycki',
    '2802': u'braniewski',
    '2803': u'działdowski',
    '2804': u'elbląski',
    '2805': u'ełcki',
    '2806': u'giżycki',
    '2807': u'iławski',
    '2808': u'kętrzyński',
    '2809': u'lidzbarski',
    '2810': u'mrągowski',
    '2811': u'nidzicki',
    '2812': u'nowomiejski',
    '2813': u'olecki',
    '2814': u'olsztyński',
    '2815': u'ostródzki',
    '2816': u'piski',
    '2817': u'szczycieński',
    '2818': u'gołdapski',
    '2819': u'węgorzewski',
    '2861': u'Elbląg',
    '2862': u'Olsztyn',
    '3001': u'chodzieski',
    '3002': u'czarnkowsko-trzcianecki',
    '3003': u'gnieźnieński',
    '3004': u'gostyński',
    '3005': u'grodziski',
    '3006': u'jarociński',
    '3007': u'kaliski',
    '3008': u'kępiński',
    '3009': u'kolski',
    '3010': u'koniński',
    '3011': u'kościański',
    '3012': u'krotoszyński',
    '3013': u'leszczyński',
    '3014': u'międzychodzki',
    '3015': u'nowotomyski',
    '3016': u'obornicki',
    '3017': u'ostrowski',
    '3018': u'ostrzeszowski',
    '3019': u'pilski',
    '3020': u'pleszewski',
    '3021': u'poznański',
    '3022': u'rawicki',
    '3023': u'słupecki',
    '3024': u'szamotulski',
    '3025': u'średzki',
    '3026': u'śremski',
    '3027': u'turecki',
    '3028': u'wągrowiecki',
    '3029': u'wolsztyński',
    '3030': u'wrzesiński',
    '3031': u'złotowski',
    '3061': u'Kalisz',
    '3062': u'Konin',
    '3063': u'Leszno',
    '3064': u'Poznań',
    '3201': u'białogardzki',
    '3202': u'choszczeński',
    '3203': u'drawski',
    '3204': u'goleniowski',
    '3205': u'gryficki',
    '3206': u'gryfiński',
    '3207': u'kamieński',
    '3208': u'kołobrzeski',
    '3209': u'koszaliński',
    '3210': u'myśliborski',
    '3211': u'policki',
    '3212': u'pyrzycki',
    '3213': u'sławieński',
    '3214': u'stargardzki',
    '3215': u'szczecinecki',
    '3216': u'świdwiński',
    '3217': u'wałecki',
    '3218': u'łobeski',
    '3261': u'Koszalin',
    '3262': u'Szczecin',
    '3263': u'Świnoujście',
}
