from django.db import models
from django.contrib.auth.models import User
    
CONTEST_CHOICES = (
    ( "A", "Bingo"),
    ( "B", "Battleship"),
    ( "C", "Bass Fishing" ),
)

class Contest(models.Model):
    name = models.CharField(max_length=32)
    promocode = models.CharField(max_length=12, null=True, blank=True, default=None)
    type = models.CharField(max_length=2,choices=CONTEST_CHOICES)
    players = models.ManyToManyField(User, through='Entry')

    def __unicode__(self):
        return "%s:%s" % (self.get_type_display(), self.name)
        
"""
    Intermediate class tracking player signups for varioius contests
"""
class Entry(models.Model):
    player = models.ForeignKey(User)
    contest = models.ForeignKey(Contest)
    date_joined = models.DateField()
    score = models.PositiveSmallIntegerField(default=0)
    place = models.PositiveSmallIntegerField(default=0)

    class Meta:
        verbose_name_plural = "Entries"

    def __unicode__(self):
        return "%s in %s %s Contest" % (self.player.username, self.contest.name, self.contest.get_type_display())
