import datetime

from django.core.management import setup_environ
import settings
setup_environ(settings)

from django.contrib.auth.models import User
from contest.models import Contest, Entry

# make a couple of users
fred = User(username="fred",email="fred@none.com",password="abcd")
fred.save()
ethel = User(username="ethel",email="ethel@none.cpm",password="wxyz")
ethel.save()

# make some contests
contest1 = Contest(name="Ralph's", type="B")
contest1.save()
contest2 = Contest(name="Harry's", type="A")
contest2.save()
contest3 = Contest(name="Gertrude's", type="A")
contest3.save()

# Now fred and etherl enter some contests
today = datetime.datetime.now().date()
entry1 = Entry(player=fred,contest=contest2,date_joined=today)
entry1.save()
entry2 = Entry(player=ethel,contest=contest1,date_joined=today)
entry2.save()
entry3 = Entry(player=fred,contest=contest1,date_joined=today)
entry3.save()

# See if we can dump and reload this data
