from django.db import models


class Person(models.Model):
    name = models.CharField(max_length=20)
    friends = models.ManyToManyField('self', through='Friendship', related_name='friend_of', symmetrical=False)

    def __unicode__(self):
	return self.name

class Friendship(models.Model):
    first = models.ForeignKey(Person, related_name='rel_from_set')
    second = models.ForeignKey(Person, related_name='rel_to_set')
    date_friended = models.DateTimeField(auto_now_add=True)

    def __unicode__(self):
	return u'%s :: %s' % (self.first.name, self.second.name)
