from django import forms
from django.utils.translation import ugettext

class CustomField(forms.RegexField):
    """
    A custom field that uses ugettext at definition time instead of ugettext_lazy
    """
    default_error_messages = {
        'invalid': ugettext('Enter a valid number'),
    }

    def __init__(self, *args, **kwargs):
        super(CustomField, self).__init__(r'^\d+$',
              max_length=None, min_length=None, *args, **kwargs)