Ticket #6095 introduced the idea of custom intermediary models. Refractoring the m2m code to always use (generic) intermediary models would have benefits:
 * a simplier implementation of m2m
 * appropriate signals are always sent when a relation is created, modified or deleted (eg. #6778)
 * extending the generic relations (using 'through=') would be easier
Of course, we must maintain compatibility to the m2m api, which consists (as far as I see it) of the ManyToManyField and the ManyRelatedManager. See the attachment for usage examples.


class Survey(models.Model):
    participants = models.ManyToManyField(User)
    
survey = Survey.objects.create()
# the m2m manager works as usual
survey.participants.add(User.objects.all())
survey.participants.remove(User.objects.get(pk=1))

# with the benefit of signals
# lets assume Survey.participants.Relation is the generic intermediary model
def notify_of_survey(sender, instance):
    survey, user = instance # do we need both objects as instance?..
    user.notify(survey)
dispatcher.connect(notify_of_survey, signal=post_save, sender=Survey.participants.Relation)

# on to another example
# the usage of through=
class Group(models.Model):
    members = models.ManyToManyField(User, through='Membership')

# as implemented in #6095
class Membership(models.Model):
    user = models.ForeignKey(User)
    group = models.ForeignKey(Group)
    joined = models.DateField()
    
# or even by extending the generic relation
# which would be abstract when through= is used.
class Membership(Group.members.Relation):
    joined = models.DateField()
    
group = Group.objects.create()
user = User.objects.get(pk=1)
# We should not remove add() etc. from the manager when using an intermediary model (as #6095 does) 
group.members.add(user) # error from Membership.save()
group.members.add(user, joined=date) # OK
group.members.add(User.objects.all(), joined=date) # all with the same date
