from django.db import models

# Create your models here.

class ShoeImage(models.Model):
	image_url = models.URLField()
	image = models.CharField( max_length=100)
	description = models.CharField( max_length=100 )
	
	def __unicode__(self):
		return self.image_url
	
class Shoe(models.Model):
	website_id = models.IntegerField()
	name = models.CharField( max_length=100 )
	brand = models.CharField( max_length=50 )
	medium_image = models.ForeignKey(ShoeImage, related_name='product_m')
	big_image = models.ForeignKey(ShoeImage, related_name='product_b')
	other_images = models.ManyToManyField( ShoeImage, related_name='product_set')	
	ori_price = models.DecimalField(max_digits=6, decimal_places=2)
	sale_price = models.DecimalField(max_digits=6, decimal_places=2)
	discount = models.DecimalField(max_digits=3, decimal_places=1)
	shipping_text = models.CharField(max_length=100 )
	url = models.URLField()
	info = models.TextField()

	def __unicode__(self):
		return self.name
