import sys, os

try:
    from lxml.etree import parse
except ImportError:
    print 'You need to install `python-lxml` to run this script'
    sys.exit(1)

convert_time = lambda x: x

# Output structure definition
output_structure = {
    "LC_TIME": {
        "d_t_fmt": {
            "pattern" : "/ldml/dates/calendars/calendar[@type='gregorian']/dateFormats/dateFormatLength[@type='long']/dateFormat/pattern",
            "conversion": convert_time,
            "xml_position": 'text',
        },
        "d_fmt": {
            "pattern" : "/ldml/dates/calendars/calendar[@type='gregorian']/dateFormats/dateFormatLength[@type='medium']/dateFormat/pattern",
            "conversion": convert_time,
            "xml_position": 'text',
        },
        "t_fmt": {
            "pattern" : "/ldml/dates/calendars/calendar[@type='gregorian']/timeFormats/timeFormatLength[@type='medium']/timeFormat/pattern",
            "conversion": convert_time,
            "xml_position": 'text',
        },
        "first_weekday": {},
    }

}

def main(cldr_dir):
    """
    For every locale defined in Django, get from the CLDR locale file all
    settings defined in output_structure, and write the result to the 
    locale directories on Django.
    """
    locale_dir = os.path.join('..', 'conf', 'locale')
    for locale_name in os.listdir(locale_dir):
        locale_file = os.path.join(cldr_dir, locale_name + '.xml')
        if os.path.isfile(locale_file):
            tree = parse(locale_file)
            result = {}
            for locale_category, keys in output_structure.iteritems():
                for key, opts in keys.iteritems():
                    if opts.get('pattern', None):
                        value = tree.xpath(opts['pattern'])
                        if len(value):
                            value = getattr(value[0], opts.get('xml_position', 'text'))
                            value = opts.get('conversion', lambda x: x)(value)
                        else:
                            value = None
                    else:
                        value = None
                    result[key] = value or u''

            # output the result to the destination file
            output_dir = os.path.join(locale_dir, locale_name, locale_category)
            if not os.path.isdir(output_dir):
                os.mkdir(output_dir)
            output_file = open(os.path.join(output_dir, 'django.po'), 'w')
            for msgstr, msgid in result.iteritems():
                output_file.write('msgstr "%s"\nmsgid "%s"\n\n' % (msgstr, msgid.encode('utf-8')))

        else:
            print 'Omitting "%s" locale' % locale_name

if __name__ == '__main__':
    if len(sys.argv) > 1 and os.path.isdir(sys.argv[1]):
        main(sys.argv[1])
    else:
        print 'Usage: %s <cldr_main_dir>' % sys.argv[0]

