
from django.db import models

# Abstract base classes with related models 
# 
 
class Post(models.Model): 
	title = models.CharField(max_length=50) 
    
class Attachment(models.Model): 
    post = models.ForeignKey(Post, related_name='attached_%(class)s_set') 
    content = models.TextField() 

    class Meta: 
        abstract = True 
 
    def __unicode__(self): 
        return self.content 
	 
class Comment(Attachment): 
	is_spam = models.BooleanField() 
	 
class Link(Attachment): 
	url = models.URLField() 
	 
# Now we create a model with a ForeignKeu=y of an abstract class

class MyAttachment(models.Model):
    mine = models.ForeignKey( Attachment )

# This fails to validate due to an internal error in related.py (line 605)
# fails in any recent trunk (i.e., rev 8506)