class LeagueSeason(models.Model):
    is_conference_used      = models.BooleanField(default=False)
    is_division_used        = models.BooleanField(default=False)

class LeagueConference(models.Model):
    league_season           = models.ForeignKey(LeagueSeason)
    name                    = models.CharField(max_length=50)
    # slug is not unique by itself.
    slug                    = models.CharField(max_length=50,prepopulate_from=('name',), db_index=True)
    sort_order              = models.SmallIntegerField(default=1)

class LeagueDivision(models.Model):
    league_conference       = models.ForeignKey(LeagueConference)
    name                    = models.CharField(max_length=50)
    # slug is not unique by itself.
    slug                    = models.CharField(max_length=50,prepopulate_from=('name',), db_index=True)
    sort_order              = models.SmallIntegerField(default=1)

