from django.db import models
from django.contrib.auth.models import User
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes import generic

class Channel(models.Model):
    creator = models.ForeignKey(User, related_name='owned_channels')
    users = models.ManyToManyField(User, related_name='subscribed_channels')
    moderators = models.ManyToManyField(User, related_name='moderated_channels')
    name = models.CharField(max_length=60, unique=True)
    topic = models.TextField()
    
    post_depth = models.CharField(max_length=3, choices=(("1", "flat"), ("2", "2-deep"), ("inf", "tree")))
    view_depth = models.CharField(max_length=1, choices=(("0", "titles"),("1", "first-level"), ("2", "second-level")))
    toplevel_order = models.CharField(max_length=2, choices=(("-", "chronologically descending by-update"),("+", "chronologically ascending by-update"),
        ("-s", "static, descending"), ("+s", "static, ascending")))
    child_order = models.CharField(max_length=2, choices=(("-", "chronologically descending by-update"),("+", "chronologically ascending by-update"),
        ("-s", "static, descending"), ("+s", "static, ascending")))
    
    anonymity = models.CharField(max_length=2, choices=(("2", "logged out users may post or view anonymously"),("1", "logged out users may only view anonymously"),
        ("0", "users must log in to view the channel")))
    registration = models.CharField(max_length=2, choices=(("2", "unregistered users may post or view"),("1", "unregistered users can only view"),
        ("0", "unregistered users cannot enter the channel")))
    
    posts = generic.GenericRelation('Post')
    
    def __unicode__(self):
        return self.name
    
    def sorted_posts(self):
        print type(self.posts)
        if self.toplevel_order in ("-","+"):
            return self.posts.all().order_by('%supdate_time' % self.toplevel_order)
        elif self.toplevel_order in ("-s", "+s"):
            return self.posts.all().order_by('%screation_time' % self.toplevel_order[0])

class Post(models.Model):
    author = models.ForeignKey(User, related_name='posts')
    title = models.CharField(max_length=60)
    content = models.TextField()
    creation_time = models.DateTimeField()
    update_time = models.DateTimeField()
    
    parent_type = models.ForeignKey(ContentType)
    parent_id = models.PositiveIntegerField()
    parent_object = generic.GenericForeignKey('parent_type', 'parent_id')
    
    replies = generic.GenericRelation('self')
    
    def __unicode__(self):
        return self.title
    
    def sorted_replies(self):
        if self.channel.child_order in ("-","+"):
            return self.replies.all().order_by('%supdate_time' % self.channel.child_order)
        elif self.channel.child_order in ("-s", "+s"):
            return self.replies.all().order_by('%screation_time' % self.channel.child_order[0])