from django.db import models

class Topping(models.Model):
    name  = models.CharField(max_length = 50)

    def __unicode__(self):
        return self.name


class Pizza(models.Model):
    name = models.CharField(max_length = 50)
    toppings = models.ManyToManyField(Topping)

    def __unicode__(self):
        return self.name

    class Meta:
        ordering = ['name', 'toppings']

## test with the following 
## create some toppings
#tomato = Topping(name="Tomato")
#tomato.save()
#mozzarella = Topping(name="Mozzarella")
#mozzarella.save()

## create a pizza
#pizza = Pizza(name="Margareta")
#pizza.save()

## add the toppings
#pizza.toppings.add(tomato)
#pizza.toppings.add(mozzarella)

#p = Pizza.objects.get(pk=1)
#Traceback (most recent call last):
#  File "<console>", line 1, in <module>
#  File "c:\python25\lib\site-packages\django\db\models\manager.py", line 82, in get return self.get_query_set().get(*args, **kwargs)
#  File "c:\python25\lib\site-packages\django\db\models\query.py", line 285, in get % (self.model._meta.object_name, num, kwargs))
#MultipleObjectsReturned: get() returned more than one Pizza -- it returned 2! Lookup parameters were {'pk': 1}

