$(document).ready( function(){
    if (GBrowserIsCompatible()) {
        map = new GMap2(document.getElementById("map"));
        map.addControl( new GLargeMapControl() );
        map.addControl( new GMapTypeControl() );
        map.setCenter(new GLatLng(43.458776, -3.795776), 13);
        GEvent.addListener(map, "click", function( overlay, point ) {
            myHtml = "Seleccionada esta ubicación";
            map.openInfoWindow(point, myHtml);
            $('#coordenadas').val( point );
        });
    }

    function showAddress(address) {
        var geocoder = new GClientGeocoder();
        geocoder.getLatLng(address, function(point){
            if (!point){
                alert(address + " no encontrada.");
            } else {
                map.setCenter(point, 16);
                var marker = new GMarker(point);
                map.addOverlay(marker);
                marker.openInfoWindowHtml(address);
                $('#coordenadas').val( point );
            }
        });
    };

    direccion = $('#id_direccion').val() + ', ' + $('#id_municipio').val() + ', ' + $('#id_cp').val();

    if ( $('#coordenadas').val() =='' ){
        showAddress( direccion );
    }else{
        coord = $('#coordenadas').val();
        m = coord.match(/(-?\d+\.\d+), (-?\d+\.\d+)/);
        coord_actuales = new GLatLng( m[1], m[2] );
        marca = new GMarker( coord_actuales );
        map.addOverlay( marca )
        marca.openInfoWindow('Su restaurante')
        map.setCenter(coord_actuales, 16);
    }

    $("#buscar").click( function(){
        direccion = $('#id_direccion').val() + ',' + $('#id_municipio').val() + ',' + $('#id_cp').val();
        showAddress( direccion );
    });

    $("#aceptar").click( function(){
        window.opener.$("#id_coordenadas").val( $("#coordenadas").val() )
        window.close();
    });

});