# coding=utf-8
from django import template
from django.conf import settings

import re

register = template.Library()

@register.filter
def thumb(value,arg):
    """Django template filter.
    Generates a thumnail image from the given url image path.
    """
    from eadmin.images import Resizer
    path = value.split( settings.MEDIA_URL )[1]

    try:
        width = int(re.search('w(\d+)',arg,re.I).groups()[0])
        height = int(re.search('h(\d+)',arg,re.I).groups()[0])
    except:
        raise template.TemplateSyntaxError, "Width or height not defined %s" % (arg)

    if re.search('c',arg,re.I):
        mode='crop'
    elif re.search('z',arg,re.I):
        mode='zoom'
    else:
        mode='normal'

    im = Resizer( path )
    image_path =  im.resize( width, height, mode )
    return im.get_absolute_url()
