#coding=utf-8
from django.http import HttpResponse,HttpResponseRedirect, Http404
from django.template import RequestContext, loader, Context
from django.shortcuts import get_object_or_404
from django.db.models import get_model, get_apps, get_app, get_models
from django.utils.translation import ugettext as _
from django.contrib.auth.decorators import login_required
import types

import pdb

def check_owner( current_model, user_field, user):
    for field in current_model._meta.fields:
        if field.name == user_field:
            if user != getattr( current_model, user_field ):
                return False

        if field.get_internal_type() == 'ForeignKey':
            #pdb.set_trace()
            parent_model = getattr( current_model, field.name)
            parent_module_name = parent_model._meta.module_name
            field_name = field.name
            if not check_owner( parent_model, user_field, user):
                return False
    #raise
    return True

def home( request ):
    from django.db import models

    class Application:
        def __init__( self, models ):
            self.name = models[0]['meta'].app_label
            self.models = models

        def __unicode__( self ):
            return self.name

    app_list=[]
    apps = get_apps()
    for app in apps:
        app_name = app.__name__.split('.')[-2]
        model_list = models.get_models(app)
        app_models = []
        for model in model_list:
            if model.__dict__.has_key('eAdmin'):
                app_models.append( {'meta':model._meta, } )
        if app_models:
            application = Application( app_models )
            app_list.append( application )
    #pdb.set_trace()
    t = loader.get_template('eadmin/inicio.html')
    c = RequestContext(request,{
                            'm_admin':True,
                            'apps':app_list,
                            }
                        )
    return HttpResponse(t.render(c))

def list(request,app,module, parent_name, parent_id):

    #Check if the model has the eadmin class
    model = get_model(app,module)
    if model.__dict__.has_key('eAdmin'):
        eadmin = model.eAdmin()
    else:
        raise Http404

    #Check the permissions for this action
    #add_p = model._meta.app_label+'.'+model._meta.get_add_permission()
    #if not request.user.has_perm( add_p ):
        #raise Http404

    #Get the parent instance
    #if parent_name == 'None':
        #parent_name = None
    if parent_name !=None:
        pdb.set_trace()
        parent = get_model( app, parent_name )
        parent = get_object_or_404( parent, id= parent_id )
    else:
        parent = None


    #Check if the object belongs to the user
    if getattr(eadmin,'user_field',None) and parent:
        if not check_owner( parent, eadmin.user_field, request.user ):
            raise Http404

    #Set the list_display
    if getattr(eadmin,'list_display',None):
        header_names = []
        attrs = []
        for d in eadmin.list_display:
            if isinstance( d, types.DictionaryType ):
                val = d.items()[0]
                header_names.append( val[0] )
                attrs.append( val[1] )
            else:
                header_names.append( d )
                attrs.append( d )
        #list_display = header_names
    #else:
        #list_display = None

    #Set the constraints
    if getattr(eadmin,'constraints',None):
        constraints = eadmin.constraints
    else:
        constraints = {}

    #Return the results filtering if necessary
    items = model.objects.all()
    if constraints:
        args = {}
        for k,v in constraints.iteritems():
            if not v in globals():
                #v = eval( v, {"__builtins__": {},"request":request,'parent_id':parent_id,'parent':parent } )
                v = eval( v )
                args[k] = v
                items = items.filter( **args )

    #Get the related objects
    related_objects = model._meta.get_all_related_objects()
    robjects = []
    for robject in related_objects:
        if robject.model.__dict__.has_key('eAdmin'):
            tmp = [ robject.model._meta.app_label, robject.model._meta.module_name, robject.model._meta.verbose_name_plural ]
            robjects.append( tmp )

    #Checks if the user has add permisions
    add_p = model._meta.app_label+'.'+model._meta.get_add_permission()
    can_add = request.user.has_perm( add_p )

    #Render
    t = loader.get_template('eadmin/list.html')
    c = RequestContext(request,{
                            'm_admin':True,
                            'items': items,
                            'header_names': header_names,
                            'col_attrs':attrs,
                            'app':app,
                            'module':module,
                            'robjects':robjects,
                            'parent_id': parent_id,
                            'parent':parent_name,
                            'can_add':can_add,
                            'tree':[]
                            }
                        )
    return HttpResponse(t.render(c))

def new_or_edit( request, app, module, parent_name, parent_id, edit=0 ):
    #Check if the model has the eadmin class
    model = get_model(app,module)
    if model.__dict__.has_key('eAdmin'):
        eadmin = model.eAdmin()
    else:
        raise Http404

    #Check the permissions for this action
    add_p = model._meta.app_label+'.'+model._meta.get_add_permission()
    if not request.user.has_perm( add_p ):
        raise Http404

    #Set the redirect url
    if not parent_name:
        admin_url= '/eadmin/%s/%s/' % ( app,module)
    else:
        admin_url= '/eadmin/%s/%s/parent_%s_%s' % ( app, module, parent_name, parent_id )

    #Get the parent instance
    #if parent_name == 'None':
        #parent_name = None
    if parent_name !=None:
        parent = get_model( app, parent_name )
        parent = get_object_or_404( parent, id= parent_id )
    else:
        parent = None

    #Set the form to use with the model
    if getattr(eadmin,'form_class',None):
        fc = eadmin.form_class
        form_class_import = __import__('%s.forms' % ( app ),[],[],[fc,])
        form_class = getattr( form_class_import, fc)

    #Set the constraints
    if getattr(eadmin,'constraints',None):
        constraints = eadmin.constraints
    else:
        constraints = {}

    #Create the form arguments
    #form_arguments = None
    #if int(edit) > 0:
        #item = get_object_or_404( model, id=edit )
        #form_arguments = {'instance':item }
    #if not request.POST and getattr( eadmin,'form_arguments',None):
        #form_arguments = {}
        #for k,v in eadmin.form_arguments.iteritems():
            ##Process the v. Example v= 'parent.comedor.restaurante.id'
            #value = eval( v )
            ##raise
            #form_arguments.update( {k:value} )

    ##Is a new or an edit?
    if int(edit) <= 0:
        item = None
        form_arguments = {}
    else:
        item = get_object_or_404( model, id=edit )
        form_arguments = {'instance':item }

    #Check if the object belongs to the user
    if getattr(eadmin,'user_field',None) and parent:
        if int(edit) <= 0:
            item_to_check = parent
        else:
            item_to_check = item
        if not check_owner( item_to_check, eadmin.user_field, request.user ):
            raise Http404, "Intento de hack, usted no es el propietario del elemento"

    #Check if the object belongs to the parent
    if int(edit) > 0 and parent_name != None:
        expected_parent = getattr( item, parent_name )
        if expected_parent != parent:
            raise Http404, "Intento de hack"



    #If the form has been submited
    if request.POST:
        if form_arguments:
            form = form_class( request.POST, **form_arguments )
        else:
            form = form_class( request.POST )
        if form.is_multipart():
            form = form_class( request.POST, request.FILES, **form_arguments )
        if form.is_valid():
            #Check if the user wants to delete a file:
            new_item = form.save(commit=False)
            if constraints:
                for k,v in constraints.iteritems():
                    if not v in globals():
                        #v = eval( v, {"__builtins__": {},"request":request,'parent_id':parent_id } )
                        v = eval( v )
                    setattr( new_item,k,v )
            new_item.save()

            if model._meta.many_to_many:
                form.save_m2m()
            return HttpResponseRedirect( admin_url )
    else:
        form= form_class( **form_arguments )

    t = loader.get_template('eadmin/new.html')
    c = RequestContext(request,{
                            'app':app,
                            'module':module,
                            'form':form,
                            'parent_id': parent_id,
                            'parent':parent_name,
                            #El item de momento no lo he usado
                            'item':item,
                            }
                        )
    return HttpResponse(t.render(c))

def delete(request, app, module, id, parent_name, parent_id ):
    #Check if the model has the eadmin class
    model = get_model(app,module)
    if model.__dict__.has_key('eAdmin'):
        eadmin = model.eAdmin()
    else:
        raise Http404

    #Retrieve the item
    item = get_object_or_404( model, id=id )

    #Check the permissions for this action
    del_p = model._meta.app_label+'.'+model._meta.get_delete_permission()
    if not request.user.has_perm( del_p ):
        raise Http404

    #Set the redirect url
    if not parent_name:
        admin_url= '/eadmin/%s/%s/' % ( app,module)
    else:
        admin_url= '/eadmin/%s/%s/parent_%s_%s' % ( app, module, parent_name, parent_id )

    #Get the parent instance
    #if parent_name == 'None':
        #parent_name = None
    if parent_name !=None:
        parent = get_model( app, parent_name )
        parent = get_object_or_404( parent, id= parent_id )
    else:
        parent = None

    #Check if the item belongs to its parent_name
    if int(id) > 0 and parent:
        parent_id_expected = getattr( item, '%s_id' % (parent_name) )
        if int(parent_id) != parent_id_expected:
            raise Http404, "This parent is not the parent expected"

    #Check if the object belongs to the user
    if getattr(eadmin,'user_field',None) and parent:
        if not check_owner( parent, eadmin.user_field, request.user ):
            raise Http404


    if request.GET.has_key('si'):
        item.delete()
    if request.GET.has_key('si') or request.GET.has_key('no'):
        return HttpResponseRedirect( admin_url )

    t = loader.get_template('eadmin/delete.html')
    c = RequestContext(request,{
                            'item': item,
                            }
                        )
    return HttpResponse(t.render(c))

