#coding=utf-8
from django.conf import settings
from math import ceil
import os

class FileNotFound( Exception ):
    "File not found "
    pass

class Resizer:
    def __init__( self, image_path ):
        import Image
        image_path = os.path.join( settings.MEDIA_ROOT , image_path )
        self.image_path = image_path
        if os.path.isfile( image_path ):
            self.im = Image.open( image_path )
        else:
            self.im = None
            #raise FileNotFound()

        self.bgcolor = (255,255,255,255 )

    def set_dimensions( self, width, height):
        self.width= int( width )
        self.height = int( height )

    def set_mode( self, mode ):
        self.mode = mode

    def set_background_color( color, alpha ):
        "Aplha must be a value between 0 and 1"
        import ImageColor
        alpha = int( float(alpha) * 255)
        self.bgcolor = ImageColor.getrgb( color )+ ( aplha, )

    def set_outfile( self ):
        assert (self.mode and self.width and self.height)

        filename = os.path.split( self.image_path )[1]
        outdir = os.path.join( settings.MEDIA_ROOT, 'image_thumbs')
        if not os.path.isdir(outdir):
            os.mkdir(outdir,0740)
        thumb_filename = os.path.splitext( filename )[0] + ".thumb_%s_%ux%u.%s" % (self.mode, self.width, self.height, self.im.format.lower() )
        outfile = os.path.join( outdir, thumb_filename )
        self.outfile = outfile

    def get_absolute_url( self ):
        if self.im:
            filename = os.path.split( self.outfile )
            return os.path.join( settings.MEDIA_URL, 'image_thumbs',filename[1])
        else:
            return ''

    def resize( self, width, height, mode ):
        import Image

        if not self.im:
            return ''

        self.set_dimensions( width, height )
        self.set_mode( mode )
        self.set_outfile()

        if os.path.isfile( self.outfile):
            if os.path.getmtime( self.outfile ) < os.path.getmtime( self.image_path ):
                os.remove( self.outfile )
        else:
            if self.mode == 'crop':
                #Crop image
                size_s = int( ceil( ( float( max( im.size ) ) / float( min( im.size ) ) ) * float( max( size ) ) ) )
                self.im.thumbnail( (size_s,size_s), Image.ANTIALIAS )

                startx = (self.im.size[0] / 2) - ( width / 2)
                endx = (self.im.size[0] / 2) + (width/2)
                starty = (self.im.size[1] / 2) - (height/2)
                endy = (self.im.size[1] / 2) + (height/2)
                region = self.im.crop( ( startx,starty,endx,endy ) )

                region.save( self.outfile, self.im.format )

            elif self.mode == 'zoom':
                self.im.thumbnail( ( self.width, self.height ), Image.ANTIALIAS )

                mode = 'RGBA'
                nim = Image.new( mode, ( self.width, self.height ), self.bgcolor)
                startx = (self.width/2)- (self.im.size[0]/2)
                starty = (self.height/2)- (self.im.size[1]/2)
                box = ( startx, starty, self.im.size[0]+startx,self.im.size[1]+starty )

                nim.paste( self.im, box )
                nim.save(self.outfile, self.im.format )
            else:
                self.im.thumbnail( ( self.width, self.height ) , Image.ANTIALIAS )
                self.im.save( self.outfile, self.im.format )

        return self.outfile
