#coding=utf-8
from django.newforms import widgets
from django.utils.safestring import mark_safe
from django.utils.translation import ugettext as _


class AdminDateWidget( widgets.TextInput ):
    #class Media:
        #js = (settings.ADMIN_MEDIA_PREFIX + "js/calendar.js",
              #settings.ADMIN_MEDIA_PREFIX + "js/admin/DateTimeShortcuts.js")

    def __init__(self, attrs={}):
        super(AdminDateWidget, self).__init__(attrs={'class': 'DateField', 'size': '10'})

class ImageWidget(widgets.FileInput):
    """
    A FileField Widget that shows a thumbnail of the image
    """
    def __init__(self, attrs={}):
        super(ImageWidget, self).__init__(attrs)

    def render(self, name, value, attrs=None):
        from django.conf import settings
        from eadmin.images import Resizer
        output = []
        if value:
            im = Resizer( value )
            thumb_path = im.resize( 100, 100, 'zoom' )
            #output.append( '%s <a href="%s%s">%s</a><br />' % ( _('Currently:'), settings.MEDIA_URL, value,value ) )
            output.append('<a target="_blank" href="%s%s"><img src="%s" alt="Thumbnail" /></a> <br />%s' % \
                ( settings.MEDIA_URL, value, im.get_absolute_url(),_('Change:') ))
            #output.append( '<input type="checkbox" id="%s_delete" name="%s_delete" /><br/>%s' % ( _(u'Delete'),name,name,_('Change:')  ) )
        output.append(super(ImageWidget, self).render(name, value, attrs))
        return mark_safe(u''.join(output))