import unittest

from nmy.qsrftest.models import Vocabulary, Term

class QsrfTestCase(unittest.TestCase):  

    def test_qsrf(self):
        v = Vocabulary.objects.create()        
            
        # Check if the new vocabulary has a root term
        self.failUnless(v.root != None,
                        'A newly created vocabulary must have a root term.')        

        # Check that the root item is associated to the vocabulary.
        self.failUnlessEqual(v, v.root.vocabulary,
                        'The vocabulary of the implicity created root term must'\
                        'be set. %s != %s'\
                         % (v, v.root.vocabulary))

        # Check cyclic correctness. This test succeeds with r7433 and fails
        # with r7599 when the ``vocabulary`` field is referenced in the
        # term's save() method.
        self.failUnlessEqual(v.root, v.root.vocabulary.root)
        