from datetime import datetime, timedelta, date
import traceback

from decimal import Decimal

from django.test import TestCase
from django.contrib.auth.models import AnonymousUser
from django.conf import settings
from django.core import mail

from django.contrib.admin.models import User

#-------------------------------------------------------------------------------
class SessionTests(TestCase):

    #-----------------------------------------------------------------------
    def test_session(self):
        # The session Doesn't exist to start.
        response = self.client.get('/get/')
        self.assertEqual(response.status_code, 200)
        self.assertEqual(response.content, 'NO')

        # This request sets the Session.
        response = self.client.get('/set/')
        self.assertEqual(response.status_code, 200)
        self.assertEqual(response.content, 'set_session')

        # now it is set.
        response = self.client.get('/get/')
        self.assertEqual(response.status_code, 200)
        self.assertEqual(response.content, 'YES')

        pw='asdf'
        user = User(email='asdf@asdf.com', username='foo')
        user.set_password(pw)
        user.is_active = True
        user.save()
        self.client.login(username=user.username, password=pw)

        # now it is set.
        response = self.client.get('/get/')
        self.assertEqual(response.status_code, 200)

        # Oops!

        self.assertEqual(response.content, 'YES')
