#
# models.py
#

from django.db import models

class Vehicle(models.Model):
	name = models.TextField()
	
	def __unicode__(self):
		return u"A vehicle called %s" % self.name

class Car(Vehicle):
	wheels = models.PositiveIntegerField(default=4)

	def __unicode__(self):
		return u"A car called %(name)s with %(wheels)s wheels" % \
			{'name': self.name, 'wheels': self.wheels}
	
class Boat(Vehicle):
	has_sail = models.BooleanField(default=True)

	def __unicode__(self):
		with_or_without = self.has_sail and "with" or "without"
		return u"A boat called %(name)s %(with_or_without)s a sail" % \
			{'name': self.name, 'with_or_without': with_or_without }
	
class Amphibian(Car, Boat):
	is_a_robot_in_disguise = models.BooleanField(default=False)
	
	def __unicode__(self):
		return u"An ampibian which is 1) %(car)s and 2) %(boat)s" % \
			{'car': Car.__unicode__(self), 
			'boat': Boat.__unicode__(self)}


#
# The code to generate the shell results.
#

from your.path.to.models import *

Vehicle.objects.all().delete()
Boat(name="dingy", has_sail=False).save()
dingy_vehicle = Vehicle.objects.get(name="dingy")
dingy_vehicle.car
dingy_vehicle.boat
dingy_vehicle.car
dingy_vehicle.boat
Car(name="my rolls", wheels=4).save()
rolls_vehicle = Vehicle.objects.get(name="my rolls")
rolls_vehicle.car
rolls_vehicle.boat
rolls_vehicle.car
rolls_vehicle.boat
amphibian = Amphibian()
amphibian.name = "optimus prime"
amphibian.has_sail = True
amphibian.wheels = 23
amphibian.is_a_robot_in_disguise = True
amphibian.save()
robot_vehicle = Vehicle.objects.get(name="optimus prime")
robot_vehicle.car
robot_vehicle.boat
robot_vehicle.car
robot_vehicle.boat
robot_vehicle.car.amphibian
robot_vehicle.boat.amphibian

# 
# Shell results before the code was changed
#

>>> Vehicle.objects.all().delete()
>>> Boat(name="dingy", has_sail=False).save()
>>> dingy_vehicle = Vehicle.objects.get(name="dingy")
>>> dingy_vehicle.car
Traceback (most recent call last):
    ...
DoesNotExist: Car matching query does not exist.
>>> dingy_vehicle.boat
<Boat: A boat called dingy without a sail>
>>> dingy_vehicle.car # should get error
<Boat: A boat called dingy without a sail>
>>> dingy_vehicle.boat
<Boat: A boat called dingy without a sail>
>>> Car(name="my rolls", wheels=4).save()
>>> rolls_vehicle = Vehicle.objects.get(name="my rolls")
>>> rolls_vehicle.car
<Car: A car called my rolls with 4 wheels>
>>> rolls_vehicle.boat # should get error
<Car: A car called my rolls with 4 wheels>
>>> rolls_vehicle.car
<Car: A car called my rolls with 4 wheels>
>>> rolls_vehicle.boat # should get error
<Car: A car called my rolls with 4 wheels>
>>> amphibian = Amphibian()
>>> amphibian.name = "optimus prime"
>>> amphibian.has_sail = True
>>> amphibian.wheels = 23
>>> amphibian.is_a_robot_in_disguise = True
>>> amphibian.save()
>>> robot_vehicle = Vehicle.objects.get(name="optimus prime")
>>> robot_vehicle.car
<Car: A car called optimus prime with 23 wheels>
>>> robot_vehicle.boat # wrong object we want to see the boat part of optimus prime
<Car: A car called optimus prime with 23 wheels>
>>> robot_vehicle.car
<Car: A car called optimus prime with 23 wheels>
>>> robot_vehicle.boat # wrong object we want to see the boat part of optimus prime
<Car: A car called optimus prime with 23 wheels>
>>> robot_vehicle.car.amphibian
<Amphibian: An ampibian which is 1) A car called optimus prime with 23 wheels and 2) A boat called optimus prime with a sail>
>>> robot_vehicle.boat.amphibian
<Amphibian: An ampibian which is 1) A car called optimus prime with 23 wheels and 2) A boat called optimus prime with a sail>

#
# Shell results after the code was changed
#

>>> Vehicle.objects.all().delete()
>>> Boat(name="dingy", has_sail=False).save()
>>> dingy_vehicle = Vehicle.objects.get(name="dingy")
>>> dingy_vehicle.car # the dingy is not a car
Traceback (most recent call last):
    ...
DoesNotExist: Car matching query does not exist.
>>> dingy_vehicle.boat
<Boat: A boat called dingy without a sail>
>>> dingy_vehicle.car # the dingy is still not a car
Traceback (most recent call last):
    ...
DoesNotExist: Car matching query does not exist.
>>> dingy_vehicle.boat
<Boat: A boat called dingy without a sail>
>>> Car(name="my rolls", wheels=4).save()
>>> rolls_vehicle = Vehicle.objects.get(name="my rolls")
>>> rolls_vehicle.car
<Car: A car called my rolls with 4 wheels>
>>> rolls_vehicle.boat
Traceback (most recent call last):
    ...
DoesNotExist: Boat matching query does not exist.
>>> rolls_vehicle.car
<Car: A car called my rolls with 4 wheels>
>>> rolls_vehicle.boat
Traceback (most recent call last):
    ...
DoesNotExist: Boat matching query does not exist.
>>> amphibian = Amphibian()
>>> amphibian.name = "optimus prime"
>>> amphibian.has_sail = True
>>> amphibian.wheels = 23
>>> amphibian.is_a_robot_in_disguise = True
>>> amphibian.save()
>>> robot_vehicle = Vehicle.objects.get(name="optimus prime")
>>> robot_vehicle.car
<Car: A car called optimus prime with 23 wheels>
>>> robot_vehicle.boat
<Boat: A boat called optimus prime with a sail>
>>> robot_vehicle.car
<Car: A car called optimus prime with 23 wheels>
>>> robot_vehicle.boat
<Boat: A boat called optimus prime with a sail>
>>> robot_vehicle.car.amphibian
<Amphibian: An ampibian which is 1) A car called optimus prime with 23 wheels and 2) A boat called optimus prime with a sail>
>>> robot_vehicle.boat.amphibian
<Amphibian: An ampibian which is 1) A car called optimus prime with 23 wheels and 2) A boat called optimus prime with a sail>