"""
>>> Base.objects.create(ext_id='b1')
<Base: Base object>
>>> SubclassA.objects.create(ext_id='sA1')
<SubclassA: SubclassA object>
>>> for b in Base.objects.all():
...   b.delete()
... 
>>> Base.objects.create(ext_id='b1')
<Base: Base object>
>>> SubclassA.objects.create(ext_id='sA1', info='foo')
<SubclassA: SubclassA object>
>>> SubclassB.objects.create(ext_id='sB1', comment='bar')
<SubclassB: SubclassB object>
>>> for ext_id in ('b1', 'sA1', 'sB1'):
...   inst = Base.objects.get(ext_id=ext_id)
...   for attrib in ('subclassa', 'subclassb'):
...     print "%s.%s: %s" % (ext_id, attrib, str(testattr(inst, attrib)))
...   inst = Base.objects.get(ext_id=ext_id)
...   for attrib in ('subclassb', 'subclassa'):
...     print "%s.%s: %s" % (ext_id, attrib, str(testattr(inst, attrib)))
... 
b1.subclassa: None
b1.subclassb: None
b1.subclassb: None
b1.subclassa: None
sA1.subclassa: SubclassA object
sA1.subclassb: None
sA1.subclassb: None
sA1.subclassa: SubclassA object
sB1.subclassa: None
sB1.subclassb: SubclassB object
sB1.subclassb: SubclassB object
sB1.subclassa: None
"""

from django.db import models
from django.core.exceptions import ObjectDoesNotExist


class Base(models.Model):
	ext_id = models.CharField(max_length=4)
	
class SubclassA(Base):
	info = models.TextField()

class SubclassB(Base):
	comment = models.TextField()


def testattr(inst, rel_name):
	try:
		return getattr(inst, rel_name)
	except ObjectDoesNotExist:
		return None

