"""
>>> from django.contrib.databrowse.datastructures import *
>>> from django.contrib.databrowse.sites import *
>>> from databrowse_inheritance.models import *
>>> site = DatabrowseSite()
>>> site.register(Base)
>>> site.register(SubclassA)
>>> b1 = Base.objects.create(ext_id='b1')
>>> ei = EasyInstance(EasyModel(site, Base), b1)
>>> # w/o the patch, this produces a DoesNotExist exception:
>>> # due to trying to access the non-existent `subclassa` member of `b1`
>>> print list(ei.related_objects())
[]
"""
from django.db import models
from django.core.exceptions import ObjectDoesNotExist


class Base(models.Model):
    ext_id = models.CharField(max_length=4)
    
class SubclassA(Base):
    info = models.TextField()


